/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.BitField;
import com.microsoft.tfs.util.Check;

public final class Platform
extends BitField {
    private static String platformString = null;
    private static Platform matchingPlatforms = null;
    public static final Platform NONE = new Platform(0, "NONE");
    public static final Platform WINDOWS = new Platform(1, "WINDOWS");
    public static final Platform GENERIC_UNIX = new Platform(2, "GENERIC_UNIX");
    public static final Platform MAC_OS_X = new Platform(4, "MAC_OS_X");
    public static final Platform LINUX = new Platform(8, "LINUX");
    public static final Platform SOLARIS = new Platform(16, "SOLARIS");
    public static final Platform AIX = new Platform(32, "AIX");
    public static final Platform HPUX = new Platform(64, "HPUX");
    public static final Platform Z_OS = new Platform(128, "Z_OS");
    public static final Platform FREEBSD = new Platform(256, "FREEBSD");

    public static final synchronized boolean isCurrentPlatform(Platform platform) {
        Check.notNull(platform, "platform");
        return Platform.getCurrentPlatform().contains(platform);
    }

    public static final synchronized Platform getCurrentPlatform() {
        if (matchingPlatforms == null) {
            String os = System.getProperty("os.name");
            if (os.startsWith("Windows")) {
                matchingPlatforms = WINDOWS;
            } else {
                matchingPlatforms = GENERIC_UNIX;
                if (os.startsWith("Mac OS X")) {
                    matchingPlatforms = matchingPlatforms.combine(MAC_OS_X);
                }
                if (os.startsWith("Linux")) {
                    matchingPlatforms = matchingPlatforms.combine(LINUX);
                }
                if (os.startsWith("SunOS")) {
                    matchingPlatforms = matchingPlatforms.combine(SOLARIS);
                }
                if (os.startsWith("AIX")) {
                    matchingPlatforms = matchingPlatforms.combine(AIX);
                }
                if (os.startsWith("HP-UX")) {
                    matchingPlatforms = matchingPlatforms.combine(HPUX);
                }
                if (os.startsWith("z/OS")) {
                    matchingPlatforms = matchingPlatforms.combine(Z_OS);
                }
                if (os.startsWith("FreeBSD")) {
                    matchingPlatforms = matchingPlatforms.combine(FREEBSD);
                }
            }
        }
        return matchingPlatforms;
    }

    public static final synchronized String getCurrentPlatformString() {
        if (platformString == null) {
            platformString = System.getProperty("os.name");
        }
        return platformString;
    }

    public static Platform combine(Platform[] changeTypes) {
        return new Platform(BitField.combine(changeTypes));
    }

    private Platform(int flags, String name) {
        super(flags);
        Platform.registerStringValue(this.getClass(), flags, name);
    }

    private Platform(int flags) {
        super(flags);
    }

    public boolean containsAll(Platform other) {
        return this.containsAllInternal(other);
    }

    public boolean contains(Platform other) {
        return this.containsInternal(other);
    }

    public boolean containsAny(Platform other) {
        return this.containsAnyInternal(other);
    }

    public Platform remove(Platform other) {
        return new Platform(this.removeInternal(other));
    }

    public Platform retain(Platform other) {
        return new Platform(this.retainInternal(other));
    }

    public Platform combine(Platform other) {
        return new Platform(this.combineInternal(other));
    }
}

