/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util;

import com.microsoft.tfs.util.Check;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public final class PlatformVersion {
    private static final Log logger = LogFactory.getLog(PlatformVersion.class);
    private static int[] platformVersion = null;
    private static Pattern componentPattern = null;
    private static final Integer INTEGER_ZERO = new Integer(0);

    public static final synchronized boolean isCurrentVersion(String versionString) {
        return PlatformVersion.compareTo(versionString) == 0;
    }

    public static final synchronized boolean isLessThanVersion(String versionString) {
        return PlatformVersion.compareTo(versionString) < 0;
    }

    public static final synchronized boolean isLessThanOrEqualToVersion(String versionString) {
        int result = PlatformVersion.compareTo(versionString);
        return result == 0 || result < 0;
    }

    public static final synchronized boolean isGreaterThanVersion(String versionString) {
        return PlatformVersion.compareTo(versionString) > 0;
    }

    public static final synchronized boolean isGreaterThanOrEqualToVersion(String versionString) {
        int result = PlatformVersion.compareTo(versionString);
        return result == 0 || result > 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int compareTo(String versionString) {
        Check.notNull(versionString, "versionString");
        Class<PlatformVersion> clazz = PlatformVersion.class;
        synchronized (PlatformVersion.class) {
            if (platformVersion == null) {
                platformVersion = PlatformVersion.parseVersionNumber(System.getProperty("os.version"));
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            int[] versionCompare = PlatformVersion.parseVersionNumber(versionString);
            for (int i = 0; i < Math.min(platformVersion.length, versionCompare.length); ++i) {
                if (platformVersion[i] < versionCompare[i]) {
                    return -1;
                }
                if (platformVersion[i] <= versionCompare[i]) continue;
                return 1;
            }
            if (platformVersion.length < versionCompare.length) {
                return -1;
            }
            if (platformVersion.length > versionCompare.length) {
                return 1;
            }
            return 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static final int[] parseVersionNumber(String versionString) {
        if (versionString == null || versionString.length() == 0) {
            return new int[0];
        }
        String[] stringComponents = versionString.split("[^a-zA-Z0-9]");
        ArrayList<Integer> versionComponents = new ArrayList<Integer>();
        Class<PlatformVersion> clazz = PlatformVersion.class;
        synchronized (PlatformVersion.class) {
            Matcher match;
            if (componentPattern == null) {
                try {
                    componentPattern = Pattern.compile("^([0-9]+)");
                }
                catch (Exception e) {
                    logger.error((Object)"Could not compile version number regex", (Throwable)e);
                    // ** MonitorExit[var3_3] (shouldn't be in output)
                    return new int[0];
                }
            }
            // ** MonitorExit[var3_3] (shouldn't be in output)
            for (int i = 0; i < stringComponents.length && (match = componentPattern.matcher(stringComponents[i])).find(); ++i) {
                try {
                    versionComponents.add(new Integer(stringComponents[i].substring(match.start(), match.end())));
                    continue;
                }
                catch (Exception e) {
                    logger.warn((Object)("Could not coerce version number into format: " + versionString), (Throwable)e);
                    break;
                }
            }
            while (versionComponents.size() > 0 && versionComponents.get(versionComponents.size() - 1).equals(INTEGER_ZERO)) {
                versionComponents.remove(versionComponents.size() - 1);
            }
            int[] version = new int[versionComponents.size()];
            for (int i = 0; i < versionComponents.size(); ++i) {
                version[i] = (Integer)versionComponents.get(i);
            }
            return version;
        }
    }
}

