/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.tfs.util.listeners;

import com.microsoft.tfs.util.Check;
import com.microsoft.tfs.util.listeners.Comparators;
import com.microsoft.tfs.util.listeners.DefaultExceptionHandler;
import com.microsoft.tfs.util.listeners.ListenerExceptionHandler;
import com.microsoft.tfs.util.listeners.ListenerList;
import com.microsoft.tfs.util.listeners.ListenerRunnable;
import java.util.ArrayList;
import java.util.Comparator;

public class StandardListenerList
implements ListenerList {
    private final Comparator comparator;
    private final Object modifyLock = new Object();
    private volatile ListenerNode listeners;

    public StandardListenerList() {
        this(Comparators.IDENTITY);
    }

    public StandardListenerList(Comparator listenerComparator) {
        Check.notNull(listenerComparator, "listenerComparator");
        this.comparator = listenerComparator;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean addListener(Object listener) {
        Check.notNull(listener, "listener");
        Object object = this.modifyLock;
        synchronized (object) {
            if (this.listeners == null) {
                this.listeners = new ListenerNode(listener, this.comparator, null);
                return true;
            }
            ListenerNodeHolder holder = new ListenerNodeHolder();
            if (this.listeners.addListener(listener, holder)) {
                this.listeners = holder.getNode();
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean clear() {
        Object object = this.modifyLock;
        synchronized (object) {
            boolean listenersExist = this.listeners != null;
            this.listeners = null;
            return listenersExist;
        }
    }

    @Override
    public boolean containsListener(Object listenerToTest) {
        Check.notNull(listenerToTest, "listenerToTest");
        ListenerNode node = this.listeners;
        while (node != null) {
            if (this.comparator.compare(listenerToTest, node.listener) == 0) {
                return true;
            }
            node = node.next;
        }
        return false;
    }

    @Override
    public void foreachListener(ListenerRunnable runnable) {
        this.foreachListener(DefaultExceptionHandler.INSTANCE, runnable);
    }

    @Override
    public void foreachListener(ListenerExceptionHandler exceptionHandler, ListenerRunnable runnable) {
        boolean keepGoing = true;
        ListenerNode node = this.listeners;
        while (node != null && keepGoing) {
            try {
                keepGoing = runnable.run(node.listener);
            }
            catch (Exception e) {
                keepGoing = exceptionHandler.onException(node.listener, runnable, this, e);
            }
            node = node.next;
        }
    }

    @Override
    public Object[] getListeners() {
        return this.getListeners(new Object[0]);
    }

    @Override
    public Object[] getListeners(Object[] a) {
        ArrayList<Object> list = new ArrayList<Object>();
        ListenerNode node = this.listeners;
        while (node != null) {
            list.add(node.listener);
            node = node.next;
        }
        return list.toArray(a);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean removeListener(Object listener) {
        Check.notNull(listener, "listener");
        Object object = this.modifyLock;
        synchronized (object) {
            if (this.listeners == null) {
                return false;
            }
            ListenerNodeHolder holder = new ListenerNodeHolder();
            if (this.listeners.removeListener(listener, holder)) {
                this.listeners = holder.getNode();
                return true;
            }
            return false;
        }
    }

    @Override
    public int size() {
        int count = 0;
        ListenerNode node = this.listeners;
        while (node != null) {
            ++count;
            node = node.next;
        }
        return count;
    }

    private static class ListenerNodeHolder {
        private ListenerNode node;

        private ListenerNodeHolder() {
        }

        public ListenerNode getNode() {
            return this.node;
        }

        public void setNode(ListenerNode node) {
            this.node = node;
        }
    }

    private static class ListenerNode {
        public final Object listener;
        public final Comparator listenerComparator;
        public final ListenerNode next;

        public ListenerNode(Object listener, Comparator listenerComparator, ListenerNode next) {
            this.listener = listener;
            this.listenerComparator = listenerComparator;
            this.next = next;
        }

        public boolean removeListener(Object listenerToRemove, ListenerNodeHolder holder) {
            if (this.listenerComparator.compare(this.listener, listenerToRemove) == 0) {
                holder.setNode(this.next);
                return true;
            }
            if (this.next == null) {
                return false;
            }
            if (this.next.removeListener(listenerToRemove, holder)) {
                holder.setNode(new ListenerNode(this.listener, this.listenerComparator, holder.getNode()));
                return true;
            }
            return false;
        }

        public boolean addListener(Object listenerToAdd, ListenerNodeHolder holder) {
            if (this.listenerComparator.compare(this.listener, listenerToAdd) == 0) {
                return false;
            }
            if (this.next == null) {
                ListenerNode node = new ListenerNode(listenerToAdd, this.listenerComparator, null);
                holder.setNode(new ListenerNode(this.listener, this.listenerComparator, node));
                return true;
            }
            if (this.next.addListener(listenerToAdd, holder)) {
                holder.setNode(new ListenerNode(this.listener, this.listenerComparator, holder.getNode()));
                return true;
            }
            return false;
        }
    }
}

