/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.cache;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.CheckForNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.php.cache.StringTable;
import org.sonar.php.cache.SymbolTableDeserializationInput;
import org.sonar.php.cache.VarLengthInputStream;
import org.sonar.php.symbols.ClassSymbol;
import org.sonar.php.symbols.ClassSymbolData;
import org.sonar.php.symbols.FunctionSymbolData;
import org.sonar.php.symbols.LocationInFileImpl;
import org.sonar.php.symbols.MethodSymbolData;
import org.sonar.php.symbols.Parameter;
import org.sonar.php.symbols.UnknownLocationInFile;
import org.sonar.php.symbols.Visibility;
import org.sonar.php.tree.symbols.SymbolQualifiedName;
import org.sonar.php.tree.symbols.SymbolReturnType;
import org.sonar.php.tree.symbols.SymbolTableImpl;
import org.sonar.plugins.php.api.symbols.QualifiedName;
import org.sonar.plugins.php.api.symbols.ReturnType;
import org.sonar.plugins.php.api.visitors.LocationInFile;

public class SymbolTableDeserializer {
    private static final Logger LOG = LoggerFactory.getLogger(SymbolTableDeserializer.class);
    private final VarLengthInputStream in;
    private final VarLengthInputStream stringTableIn;
    private final String pluginVersion;
    private StringTable stringTable;

    private SymbolTableDeserializer(VarLengthInputStream in, VarLengthInputStream stringTableIn, String pluginVersion) {
        this.in = in;
        this.stringTableIn = stringTableIn;
        this.pluginVersion = pluginVersion;
    }

    @CheckForNull
    public static SymbolTableImpl fromBinary(SymbolTableDeserializationInput input) {
        SymbolTableDeserializer deserializer = new SymbolTableDeserializer(new VarLengthInputStream(input.projectSymbolDataBytes()), new VarLengthInputStream(input.stringTable()), input.pluginVersion());
        return deserializer.convert();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private SymbolTableImpl convert() {
        try (VarLengthInputStream varLengthInputStream = this.in;){
            SymbolTableImpl symbolTableImpl;
            block21: {
                ArrayList<FunctionSymbolData> functionSymbolData;
                ArrayList<ClassSymbolData> classSymbolData;
                VarLengthInputStream varLengthInputStream2;
                block19: {
                    SymbolTableImpl symbolTableImpl2;
                    block20: {
                        varLengthInputStream2 = this.stringTableIn;
                        classSymbolData = new ArrayList<ClassSymbolData>();
                        functionSymbolData = new ArrayList<FunctionSymbolData>();
                        this.stringTable = this.readStringTable();
                        String pluginVersionText = this.readString();
                        if (pluginVersionText.equals(this.pluginVersion)) break block19;
                        symbolTableImpl2 = null;
                        if (varLengthInputStream2 == null) break block20;
                        varLengthInputStream2.close();
                    }
                    return symbolTableImpl2;
                }
                try {
                    int sizeOfClassSymbols = this.readInt();
                    for (int i = 0; i < sizeOfClassSymbols; ++i) {
                        ClassSymbolData data = this.readClassSymbolData();
                        classSymbolData.add(data);
                    }
                    int sizeOfFuncSymbols = this.readInt();
                    for (int i = 0; i < sizeOfFuncSymbols; ++i) {
                        FunctionSymbolData data = this.readFunctionSymbolDataList();
                        functionSymbolData.add(data);
                    }
                    if (!"END".equals(this.in.readUTF())) {
                        throw new IOException("Can't read data from cache, format corrupted");
                    }
                    symbolTableImpl = SymbolTableImpl.create(classSymbolData, functionSymbolData);
                    if (varLengthInputStream2 == null) break block21;
                }
                catch (Throwable throwable) {
                    if (varLengthInputStream2 != null) {
                        try {
                            varLengthInputStream2.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                varLengthInputStream2.close();
            }
            return symbolTableImpl;
        }
        catch (IOException e) {
            LOG.debug("Can't deserialize data from the cache", e);
            return null;
        }
    }

    private FunctionSymbolData readFunctionSymbolDataList() throws IOException {
        LocationInFile location = this.readLocation();
        QualifiedName qualifiedName = this.readQualifiedName();
        List<Parameter> parameters = this.readParameters();
        FunctionSymbolData.FunctionSymbolProperties properties = this.readProperties();
        ReturnType returnType = this.readReturnType();
        return new FunctionSymbolData(location, qualifiedName, parameters, properties, returnType);
    }

    private FunctionSymbolData.FunctionSymbolProperties readProperties() throws IOException {
        boolean hasReturn = this.readBoolean();
        boolean hasFuncGetArgs = this.readBoolean();
        return new FunctionSymbolData.FunctionSymbolProperties(hasReturn, hasFuncGetArgs);
    }

    private QualifiedName readQualifiedName() throws IOException {
        String name = this.readString();
        return SymbolQualifiedName.qualifiedName(name);
    }

    private QualifiedName readQualifiedNameOrNull() throws IOException {
        String name = this.readString();
        if (name.isBlank()) {
            return null;
        }
        return SymbolQualifiedName.qualifiedName(name);
    }

    private ReturnType readReturnType() throws IOException {
        boolean isDefined = this.readBoolean();
        boolean isVoid = this.readBoolean();
        return new SymbolReturnType(isDefined, isVoid);
    }

    private ClassSymbolData readClassSymbolData() throws IOException {
        LocationInFile location = this.readLocation();
        QualifiedName qualifiedName = this.readQualifiedName();
        QualifiedName superClass = this.readQualifiedNameOrNull();
        int sizeOfImplementedInterfaces = this.readInt();
        ArrayList<QualifiedName> implementedInterfaces = new ArrayList<QualifiedName>();
        for (int i = 0; i < sizeOfImplementedInterfaces; ++i) {
            QualifiedName implInterface = this.readQualifiedName();
            implementedInterfaces.add(implInterface);
        }
        String kindText = this.readString();
        int numberOfMethods = this.readInt();
        ArrayList<MethodSymbolData> methods = new ArrayList<MethodSymbolData>();
        for (int i = 0; i < numberOfMethods; ++i) {
            MethodSymbolData method = this.readMethod();
            methods.add(method);
        }
        return new ClassSymbolData(location, qualifiedName, superClass, implementedInterfaces, ClassSymbol.Kind.valueOf(kindText), methods);
    }

    private LocationInFile readLocation() throws IOException {
        String filePath = this.readString();
        if ("[unknown file]".equals(filePath)) {
            return UnknownLocationInFile.UNKNOWN_LOCATION;
        }
        int startLine = this.readInt();
        int startLineOffset = this.readInt();
        int endLine = this.readInt();
        int endLineOffset = this.readInt();
        return new LocationInFileImpl(filePath, startLine, startLineOffset, endLine, endLineOffset);
    }

    private MethodSymbolData readMethod() throws IOException {
        Visibility visibility = Visibility.valueOf(this.readString());
        String name = this.readString();
        boolean isAbstract = this.readBoolean();
        boolean isTestMethod = this.readBoolean();
        LocationInFile location = this.readLocation();
        List<Parameter> parameters = this.readParameters();
        boolean hasReturn = this.readBoolean();
        boolean hasFuncGetArgs = this.readBoolean();
        ReturnType returnType = this.readReturnType();
        FunctionSymbolData.FunctionSymbolProperties properties = new FunctionSymbolData.FunctionSymbolProperties(hasReturn, hasFuncGetArgs);
        return new MethodSymbolData(location, name, parameters, properties, visibility, returnType, isAbstract, isTestMethod);
    }

    private List<Parameter> readParameters() throws IOException {
        int size = this.readInt();
        ArrayList<Parameter> parameters = new ArrayList<Parameter>();
        for (int i = 0; i < size; ++i) {
            String name = this.readString();
            String type = this.readString();
            String typeOrNull = "".equals(type) ? null : type;
            boolean hasDefault = this.readBoolean();
            boolean hasEllipsisOperator = this.readBoolean();
            parameters.add(new Parameter(name, typeOrNull, hasDefault, hasEllipsisOperator));
        }
        return parameters;
    }

    private int readInt() throws IOException {
        return this.in.readInt();
    }

    private boolean readBoolean() throws IOException {
        return this.in.readBoolean();
    }

    private String readString() throws IOException {
        return this.stringTable.getString(this.in.readInt());
    }

    private StringTable readStringTable() throws IOException {
        int size = this.stringTableIn.readInt();
        ArrayList<String> byIndex = new ArrayList<String>(size);
        for (int i = 0; i < size; ++i) {
            byIndex.add(this.stringTableIn.readUTF());
        }
        if (!"END".equals(this.stringTableIn.readUTF())) {
            throw new IOException("Can't read data from cache, format corrupted");
        }
        return new StringTable(byIndex);
    }
}

