/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks;

import java.util.regex.Pattern;
import org.sonar.check.Rule;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.expression.LiteralTree;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

@Rule(key="S1314")
public class UseOfOctalValueCheck
extends PHPVisitorCheck {
    public static final String KEY = "S1314";
    private static final String MESSAGE = "Use decimal rather than octal values.";
    private static final Pattern OCTAL_NUMERIC_PATTERN = Pattern.compile("^0[0-7]+(_[0-7]+)?+$");

    @Override
    public void visitLiteral(LiteralTree tree) {
        if (tree.is(Tree.Kind.NUMERIC_LITERAL)) {
            this.checkNumericValue(tree);
        }
        super.visitLiteral(tree);
    }

    private void checkNumericValue(LiteralTree tree) {
        String value = tree.value().replace("_", "");
        if (OCTAL_NUMERIC_PATTERN.matcher(value).find() && !UseOfOctalValueCheck.isException(value)) {
            this.context().newIssue(this, tree, MESSAGE);
        }
    }

    private static boolean isException(String value) {
        return value.length() == 4 || value.length() == 2;
    }
}

