/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.phpunit;

import java.util.Optional;
import javax.annotation.CheckForNull;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.PhpUnitCheck;
import org.sonar.php.tree.TreeUtils;
import org.sonar.plugins.php.api.tree.SeparatedList;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.declaration.CallArgumentTree;
import org.sonar.plugins.php.api.tree.declaration.MethodDeclarationTree;
import org.sonar.plugins.php.api.tree.declaration.ParameterTree;
import org.sonar.plugins.php.api.tree.expression.ArrayAccessTree;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;
import org.sonar.plugins.php.api.tree.expression.IdentifierTree;
import org.sonar.plugins.php.api.tree.expression.MemberAccessTree;
import org.sonar.plugins.php.api.tree.expression.VariableIdentifierTree;

@Rule(key="S3415")
public class AssertionArgumentOrderCheck
extends PhpUnitCheck {
    private static final String MESSAGE = "Swap these 2 arguments so they are in the correct order: expected value, actual value.";
    private static final String SECONDARY_MESSAGE = "Other argument to swap.";
    private static final Tree.Kind[] LITERAL = new Tree.Kind[]{Tree.Kind.BOOLEAN_LITERAL, Tree.Kind.NULL_LITERAL, Tree.Kind.NUMERIC_LITERAL, Tree.Kind.EXPANDABLE_STRING_LITERAL, Tree.Kind.REGULAR_STRING_LITERAL};

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        if (!this.isPhpUnitTestMethod()) {
            return;
        }
        Optional<PhpUnitCheck.Assertion> assertion = AssertionArgumentOrderCheck.getAssertion(tree);
        SeparatedList<CallArgumentTree> arguments = tree.callArguments();
        if (arguments.size() >= 2 && assertion.isPresent() && assertion.get().hasExpectedValue() && !CheckUtils.hasNamedArgument(tree)) {
            ExpressionTree expected = ((CallArgumentTree)arguments.get(0)).value();
            ExpressionTree actual = ((CallArgumentTree)arguments.get(1)).value();
            if (AssertionArgumentOrderCheck.isLiteralOrClassNameOrParameter(actual) && !AssertionArgumentOrderCheck.isLiteralOrClassNameOrParameter(expected)) {
                this.newIssue(actual, MESSAGE).secondary(expected, SECONDARY_MESSAGE);
            }
        }
        super.visitFunctionCall(tree);
    }

    private static boolean isLiteralOrClassNameOrParameter(ExpressionTree expression) {
        return CheckUtils.assignedValue(expression).is(LITERAL) || AssertionArgumentOrderCheck.isStaticAccessWithName(expression, "class") || AssertionArgumentOrderCheck.isDefinedFromParameter(expression);
    }

    private static boolean isStaticAccessWithName(ExpressionTree expression, String memberName) {
        if (expression instanceof MemberAccessTree) {
            MemberAccessTree tree = (MemberAccessTree)expression;
            return tree.isStatic() && memberName.equals(AssertionArgumentOrderCheck.sourceVariableName(tree.member()));
        }
        return false;
    }

    private static boolean isDefinedFromParameter(ExpressionTree expression) {
        MethodDeclarationTree method = (MethodDeclarationTree)TreeUtils.findAncestorWithKind((Tree)expression, Tree.Kind.METHOD_DECLARATION);
        if (method != null) {
            String name = AssertionArgumentOrderCheck.sourceVariableName(expression);
            for (ParameterTree parameter : method.parameters().parameters()) {
                String text = parameter.variableIdentifier().text();
                if (!text.equals(name)) continue;
                return true;
            }
        }
        return false;
    }

    @CheckForNull
    private static String sourceVariableName(Tree expression) {
        ArrayAccessTree arrayAccessTree;
        ExpressionTree expressionTree;
        if (expression instanceof IdentifierTree) {
            IdentifierTree identifier = (IdentifierTree)expression;
            return identifier.text();
        }
        if (expression instanceof ArrayAccessTree && (expressionTree = (arrayAccessTree = (ArrayAccessTree)expression).object()) instanceof VariableIdentifierTree) {
            VariableIdentifierTree variableIdentifierTree = (VariableIdentifierTree)expressionTree;
            return variableIdentifierTree.token().text();
        }
        return null;
    }
}

