/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.security;

import java.util.Set;
import org.sonar.check.Rule;
import org.sonar.php.checks.utils.CheckUtils;
import org.sonar.php.checks.utils.argumentmatching.ArgumentVerifierValueContainment;
import org.sonar.php.checks.utils.argumentmatching.FunctionArgumentCheck;
import org.sonar.plugins.php.api.tree.expression.ExpressionTree;
import org.sonar.plugins.php.api.tree.expression.FunctionCallTree;

@Rule(key="S4790")
public class CryptographicHashCheck
extends FunctionArgumentCheck {
    private static final String MESSAGE = "Make sure this weak hash algorithm is not used in a sensitive context here.";
    private static final Set<String> WEAK_HASH_FUNCTIONS = Set.of("md5", "sha1");
    private static final Set<String> WEAK_HASH_ARGUMENTS = Set.of("md2", "md4", "md5", "sha1", "sha224", "ripemd128", "ripemd160", "haval160,3", "haval192,3", "haval224,3");
    private static final Set<String> WEAK_MHASH_ARGUMENTS = Set.of("MHASH_MD2", "MHASH_MD4", "MHASH_MD5", "MHASH_RIPEMD128", "MHASH_SHA1", "MHASH_SHA192", "MHASH_SHA224", "MHASH_HAVAL128", "MHASH_HAVAL160", "MHASH_HAVAL192", "MHASH_HAVAL224");
    private static final ArgumentVerifierValueContainment hashArgumentVerifier = ((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)ArgumentVerifierValueContainment.builder().position(0)).name("algo")).values(WEAK_HASH_ARGUMENTS)).build();
    private static final ArgumentVerifierValueContainment mHashArgumentVerifier = ((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)((ArgumentVerifierValueContainment.ArgumentVerifierValueContainmentBuilder)ArgumentVerifierValueContainment.builder().position(0)).name("hash")).values(WEAK_MHASH_ARGUMENTS)).build();

    @Override
    public void visitFunctionCall(FunctionCallTree tree) {
        super.visitFunctionCall(tree);
        String functionName = CheckUtils.getLowerCaseFunctionName(tree);
        if (functionName != null && WEAK_HASH_FUNCTIONS.contains(functionName)) {
            this.createIssue(tree);
            return;
        }
        this.checkArgument(tree, "hash_init", hashArgumentVerifier);
        this.checkArgument(tree, "hash", hashArgumentVerifier);
        this.checkArgument(tree, "hash_pbkdf2", hashArgumentVerifier);
        this.checkArgument(tree, "mhash", mHashArgumentVerifier);
    }

    protected void createIssue(FunctionCallTree tree) {
        this.context().newIssue(this, tree.callee(), MESSAGE);
    }

    @Override
    protected void createIssue(ExpressionTree argument) {
        this.context().newIssue(this, argument, MESSAGE);
    }
}

