/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import org.apache.commons.lang3.StringUtils;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;
import org.sonar.plugins.php.api.visitors.PHPVisitorCheck;

public abstract class AbstractCommentContainsPatternCheck
extends PHPVisitorCheck {
    protected abstract String pattern();

    protected abstract String message();

    @Override
    public void visitTrivia(SyntaxTrivia trivia) {
        String comment = trivia.text();
        if (StringUtils.containsIgnoreCase(comment, this.pattern())) {
            String[] lines = comment.split("\r\n?|\n");
            for (int i = 0; i < lines.length; ++i) {
                if (!StringUtils.containsIgnoreCase(lines[i], this.pattern()) || this.isLetterAround(lines[i])) continue;
                this.createIssue(trivia.line() + i);
            }
        }
    }

    private boolean isLetterAround(String line) {
        int start = StringUtils.indexOfIgnoreCase(line, this.pattern());
        int end = start + this.pattern().length();
        boolean pre = start > 0 && Character.isLetter(line.charAt(start - 1));
        boolean post = end < line.length() - 1 && Character.isLetter(line.charAt(end));
        return pre || post;
    }

    private void createIssue(int line) {
        this.context().newLineIssue(this, line, this.message());
    }
}

