/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.checks.utils;

import java.util.Iterator;
import javax.annotation.Nullable;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.plugins.php.api.tree.Tree;

public final class SyntacticEquivalence {
    private SyntacticEquivalence() {
    }

    public static boolean areSyntacticallyEquivalent(@Nullable Tree tree1, @Nullable Tree tree2) {
        if (tree1 == tree2) {
            return true;
        }
        if (tree1 == null || tree2 == null) {
            return false;
        }
        PHPTree phpTree1 = (PHPTree)tree1;
        PHPTree phpTree2 = (PHPTree)tree2;
        if (phpTree1.getKind() != phpTree2.getKind()) {
            return false;
        }
        if (phpTree1.isLeaf()) {
            return phpTree1.getFirstToken().text().equals(phpTree2.getFirstToken().text());
        }
        Iterator<Tree> iterator1 = phpTree1.childrenIterator();
        Iterator<Tree> iterator2 = phpTree2.childrenIterator();
        return SyntacticEquivalence.areSyntacticallyEquivalent(iterator1, iterator2);
    }

    public static boolean areSyntacticallyEquivalent(Iterable<? extends Tree> iterable1, Iterable<? extends Tree> iterable2) {
        return SyntacticEquivalence.areSyntacticallyEquivalent(iterable1.iterator(), iterable2.iterator());
    }

    public static boolean areSyntacticallyEquivalent(Iterator<? extends Tree> iterator1, Iterator<? extends Tree> iterator2) {
        while (iterator1.hasNext() && iterator2.hasNext()) {
            if (SyntacticEquivalence.areSyntacticallyEquivalent(iterator1.next(), iterator2.next())) continue;
            return false;
        }
        return !iterator1.hasNext() && !iterator2.hasNext();
    }
}

