/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.php.tree;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.Spliterator;
import java.util.Spliterators;
import java.util.function.Predicate;
import java.util.stream.Stream;
import java.util.stream.StreamSupport;
import javax.annotation.CheckForNull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;
import org.sonar.php.tree.impl.PHPTree;
import org.sonar.php.utils.collections.ListUtils;
import org.sonar.plugins.php.api.tree.Tree;
import org.sonar.plugins.php.api.tree.lexical.SyntaxTrivia;

public class TreeUtils {
    private TreeUtils() {
    }

    public static boolean isDescendant(Tree tree, Tree potentialParent) {
        Tree parent;
        for (parent = tree; parent != null && !potentialParent.equals(parent); parent = parent.getParent()) {
        }
        return potentialParent.equals(parent);
    }

    @CheckForNull
    public static Tree findAncestorWithKind(Tree tree, Collection<Tree.Kind> kinds) {
        Tree parent;
        for (parent = tree; parent != null && !kinds.contains(parent.getKind()); parent = parent.getParent()) {
        }
        return parent;
    }

    @CheckForNull
    public static Tree findAncestorWithKind(Tree tree, Tree.Kind ... kinds) {
        return TreeUtils.findAncestorWithKind(tree, Arrays.asList(kinds));
    }

    public static Stream<Tree> descendants(@Nullable Tree root) {
        if (root == null || ((PHPTree)root).isLeaf()) {
            return Stream.empty();
        }
        Spliterator<Tree> spliterator = Spliterators.spliteratorUnknownSize(((PHPTree)root).childrenIterator(), 16);
        Stream<Tree> stream = StreamSupport.stream(spliterator, false);
        return stream.flatMap(tree -> Stream.concat(Stream.of(tree), TreeUtils.descendants(tree)));
    }

    public static <T extends Tree> Stream<T> descendants(@Nullable Tree root, Class<T> clazz) {
        return TreeUtils.descendants(root).filter(clazz::isInstance).map(clazz::cast);
    }

    public static Optional<Tree> firstDescendant(@Nullable Tree root, Predicate<Tree> predicate) {
        return TreeUtils.descendants(root).filter(predicate).findFirst();
    }

    public static <T extends Tree> Optional<T> firstDescendant(Tree root, Class<T> clazz) {
        return TreeUtils.firstDescendant(root, clazz::isInstance);
    }

    public static boolean hasAnnotation(Tree declaration, String annotation) {
        List<SyntaxTrivia> trivias;
        if (!((String)annotation).startsWith("@")) {
            annotation = "@" + (String)annotation;
        }
        if (!(trivias = ((PHPTree)declaration).getFirstToken().trivias()).isEmpty()) {
            return StringUtils.containsIgnoreCase(ListUtils.getLast(trivias).text(), (CharSequence)annotation);
        }
        return false;
    }
}

