/*
 * Decompiled with CFR 0.152.
 */
package org.sonar.plugins.php.reports.phpunit;

import java.io.File;
import java.io.IOException;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.sonar.api.batch.fs.FileSystem;
import org.sonar.api.batch.fs.InputFile;
import org.sonar.api.batch.sensor.SensorContext;
import org.sonar.api.batch.sensor.coverage.NewCoverage;
import org.sonar.plugins.php.reports.phpunit.CoverageFileParserForPhpUnit;
import org.sonar.plugins.php.reports.phpunit.PhpUnitReportImporter;
import org.sonar.plugins.php.reports.phpunit.xml.FileNode;
import org.sonar.plugins.php.reports.phpunit.xml.LineNode;
import org.sonar.plugins.php.warning.AnalysisWarningsWrapper;
import org.sonarsource.analyzer.commons.xml.ParseException;

public class CoverageResultImporter
extends PhpUnitReportImporter {
    private static final Logger LOG = LoggerFactory.getLogger(CoverageResultImporter.class);
    private static final String WRONG_LINE_EXCEPTION_MESSAGE = "Line with number {} doesn't belong to file {}";
    private static final String COVERAGE_REPORT_DOES_NOT_CONTAIN_ANY_RECORD = "Coverage report does not contain any record in file %s";
    private final CoverageFileParserForPhpUnit parser = new CoverageFileParserForPhpUnit();

    public CoverageResultImporter(AnalysisWarningsWrapper analysisWarningsWrapper) {
        super(analysisWarningsWrapper);
    }

    @Override
    public void importReport(File report, SensorContext context) throws IOException, ParseException {
        LOG.info("Importing {}", (Object)report);
        CoverageMeasureRecorder recorder = new CoverageMeasureRecorder(this, context);
        this.parser.parse(report, recorder);
        if (recorder.fileNodeCount == 0) {
            this.createWarning(COVERAGE_REPORT_DOES_NOT_CONTAIN_ANY_RECORD, report);
        }
    }

    private void saveCoverageMeasure(FileNode fileNode, SensorContext context) {
        FileSystem fileSystem = context.fileSystem();
        String path = this.fileHandler.relativePath(fileNode.getName());
        InputFile inputFile = fileSystem.inputFile(fileSystem.predicates().hasPath(path));
        if (inputFile != null) {
            CoverageResultImporter.saveCoverageLineHitsData(fileNode, inputFile, context);
        } else {
            this.addUnresolvedInputFile(path);
        }
    }

    private static void saveCoverageLineHitsData(FileNode fileNode, InputFile inputFile, SensorContext context) {
        NewCoverage newCoverage = context.newCoverage().onFile(inputFile);
        if (fileNode.getLines() != null) {
            for (LineNode line : fileNode.getLines()) {
                int lineNum = line.getNum();
                if (lineNum > 0 && lineNum <= inputFile.lines()) {
                    newCoverage.lineHits(line.getNum(), line.getCount());
                    continue;
                }
                String filename = inputFile.filename();
                LOG.warn(WRONG_LINE_EXCEPTION_MESSAGE, (Object)lineNum, (Object)filename);
            }
        }
        newCoverage.save();
    }

    @Override
    public String reportPathKey() {
        return "sonar.php.coverage.reportPaths";
    }

    @Override
    public String reportName() {
        return "PHPUnit coverage";
    }

    @Override
    public Logger logger() {
        return LOG;
    }

    private static class CoverageMeasureRecorder
    implements Consumer<FileNode> {
        private final CoverageResultImporter importer;
        SensorContext context;
        protected int fileNodeCount = 0;

        public CoverageMeasureRecorder(CoverageResultImporter importer, SensorContext context) {
            this.importer = importer;
            this.context = context;
        }

        @Override
        public void accept(FileNode fileNode) {
            this.importer.saveCoverageMeasure(fileNode, this.context);
            ++this.fileNodeCount;
        }
    }
}

