/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.abap.CallStatementCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.util.CheckUtils;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import java.util.Set;
import org.conqat.lib.commons.collections.CollectionUtils;

@Check(id="cqse-call-ws-function", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class CallWsFunctionCheck
extends CallStatementCheckBase {
    private static final Set<String> SUSPICIOUS_FUNCTIONS = CollectionUtils.asHashSet((Object[])new String[]{"WS_QUERY", "WS_EXECUTE"});

    @Override
    protected void processCallStatement() throws CheckException {
        if (this.getCallStatmentTokens().size() < 3) {
            return;
        }
        String function = CheckUtils.getUnquotedTextForCharacterLiteral((IToken)((IToken)this.getCallStatmentTokens().get(2)));
        if (SUSPICIOUS_FUNCTIONS.contains(function)) {
            this.buildFinding("Call of function " + function, this.buildLocation().forEntity(this.getCallStatement())).createAndStore();
        }
    }

    @Override
    protected boolean isTargetedCallStatement(ETokenType typeOfsecondToken) {
        return typeOfsecondToken == ETokenType.FUNCTION;
    }
}

