/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.abap;

import eu.cqse.check.base.EntityCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import java.util.List;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-read-table-memory-assign", languages={ELanguage.ABAP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ReadTableMemoryAssignCheck
extends EntityCheckBase {
    protected String getXPathSelectionString() {
        return "//STATEMENT";
    }

    protected void processEntity(ShallowEntity entity) throws CheckException {
        UnmodifiableList tokens = entity.includedTokens();
        if (!TokenStreamUtils.startsWith((List)tokens, (ETokenType[])new ETokenType[]{ETokenType.READ, ETokenType.TABLE})) {
            return;
        }
        int findingIndex = TokenStreamUtils.firstTokenOfTypeSequence((List)tokens, (int)2, (ETokenType[])new ETokenType[]{ETokenType.INTO, ETokenType.LT});
        if (findingIndex != -1) {
            this.buildFinding("`READ TABLE` using `INTO` with field-symbol", this.buildLocation().forTokens(tokens.subList(findingIndex, findingIndex + 2))).createAndStore();
        }
    }
}

