/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-bad-assignments", languages={ELanguage.JAVA, ELanguage.XTEND, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class BadAssignmentsCheck
extends CheckImplementationBase {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final String CHECK_NAME = "Bad assignments";
    public static final Set<String> SIMPLE_CONDITION_SUBTYPES = Set.of("while", "if", "else if", "elseif");
    @CheckOption(name="Bad assignments: Allow variable initialization in conditions", description="Whether variables initializations inside conditional statements should be allowed or not.")
    private boolean allowVariableInitializationsInConditions = false;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            List conditionTokens2;
            UnmodifiableList tokens;
            if (SIMPLE_CONDITION_SUBTYPES.contains(statement.getSubtype())) {
                tokens = statement.ownStartTokens();
                int equalSignIndex = TokenStreamUtils.firstTokenMatchingIndexPredicate((List)tokens, (int)0, (index, conditionTokens) -> ((IToken)conditionTokens.get((int)index)).getType() == ETokenType.EQ);
                if (equalSignIndex == -1 || this.isFiltered(statement, (List<IToken>)tokens, equalSignIndex)) continue;
                this.buildFinding("Avoid assignments in `" + statement.getSubtype() + "` statements", this.buildLocation().forEntityFirstLine(statement)).createAndStore();
                continue;
            }
            if (!"for".equals(statement.getSubtype()) || TokenStreamUtils.count((List)(conditionTokens2 = TokenStreamUtils.tokensBetween((List)(tokens = statement.ownStartTokens()), (ETokenType)ETokenType.SEMICOLON, (ETokenType)ETokenType.SEMICOLON)), (ETokenType)ETokenType.EQ) <= 0) continue;
            this.buildFinding("Avoid assignments in condition of `" + statement.getSubtype() + "` statements", this.buildLocation().forEntityFirstLine(statement)).createAndStore();
        }
    }

    private boolean isFiltered(ShallowEntity statement, List<IToken> tokens, int equalSignIndex) {
        return this.allowVariableInitializationsInConditions && BadAssignmentsCheck.isVariableDefinition(tokens, equalSignIndex) || this.isObjectiveCInitFunctionAssignment(statement, tokens, equalSignIndex);
    }

    private static boolean isVariableDefinition(List<IToken> tokens, int equalSignIndex) {
        for (int indexOfPossibleTypeName = equalSignIndex - 2; indexOfPossibleTypeName >= 0; --indexOfPossibleTypeName) {
            ETokenType typeOfPossibleTypeNameToken = tokens.get(indexOfPossibleTypeName).getType();
            if (typeOfPossibleTypeNameToken.equals((Object)ETokenType.MULT) || typeOfPossibleTypeNameToken.equals((Object)ETokenType.AND)) continue;
            return typeOfPossibleTypeNameToken.isIdentifier() || typeOfPossibleTypeNameToken.isKeyword();
        }
        return false;
    }

    private boolean isObjectiveCInitFunctionAssignment(ShallowEntity statement, List<IToken> tokens, int equalSignIndex) {
        if (this.context.getLanguage().isObjectiveCOrObjectiveCpp() && statement.getSubtype().equals("if")) {
            if (equalSignIndex - 1 < 0 || equalSignIndex + 1 >= tokens.size() || equalSignIndex + 2 >= tokens.size()) {
                LOGGER.error("The {} file {} has an unknown 'if' construct in line {}. This indicates a parser problem.", (Object)this.context.getLanguage(), (Object)this.context.getUniformPath(), (Object)statement.getStartLine());
                return false;
            }
            IToken tokenBeforeEquals = tokens.get(equalSignIndex - 1);
            IToken firstTokenAfterEqual = tokens.get(equalSignIndex + 1);
            IToken secondTokenAfterEqual = tokens.get(equalSignIndex + 2);
            return tokenBeforeEquals.getType() == ETokenType.SELF && firstTokenAfterEqual.getType() == ETokenType.LBRACK && EnumSet.of(ETokenType.SELF, ETokenType.SUPER).contains(secondTokenAfterEqual.getType());
        }
        return false;
    }
}

