/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.clike;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.conqat.lib.commons.html.EHTMLElement;

@Check(id="cqse-html-in-string", languages={ELanguage.JAVA, ELanguage.CS, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class HtmlInStringCheck
extends CheckImplementationBase {
    public static final String NAME = "Avoid building HTML in Strings";
    private static final String MESSAGE = "HTML tag is contained in String";
    private static final Pattern TAG_PATTERN = Pattern.compile("<([^> ]+)>");
    private static final HashSet<String> HTML_TAGS = new HashSet();

    public void execute() throws CheckException {
        List attributes = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.ATTRIBUTE);
        for (ShallowEntity attribute : attributes) {
            if (!TokenStreamUtils.contains((List)attribute.ownStartTokens(), (ETokenType)ETokenType.STRING_LITERAL)) continue;
            this.processEntity(attribute);
        }
    }

    private void processEntity(ShallowEntity entity) {
        List<IToken> literals = entity.includedTokens().stream().filter(token -> token.getType() == ETokenType.STRING_LITERAL).toList();
        for (IToken literal : literals) {
            Matcher matcher = TAG_PATTERN.matcher(literal.getText());
            while (matcher.find()) {
                if (!HTML_TAGS.contains(matcher.group(1))) continue;
                this.buildFinding(MESSAGE, this.buildLocation().forEntity(entity)).createAndStore();
                return;
            }
        }
    }

    static {
        for (EHTMLElement element : EnumSet.allOf(EHTMLElement.class)) {
            HTML_TAGS.add(element.toString());
        }
    }
}

