/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;

@Check(id="cqse-types-shall-be-explicitly-specified", languages={ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class TypesShallBeExplicitlySpecifiedCheck
extends CheckImplementationBase {
    private static final int TYPEDEF_RETURN_TYPE_GROUP = 0;
    private static final int TYPEDEF_PARAMETERS_GROUP = 1;
    private static final TokenPattern TYPEDEF_PATTERN = new TokenPattern().skipNested((Object)ETokenType.TYPEDEF, (Object)ETokenType.LPAREN, false).group(0).sequence(new Object[]{ETokenType.MULT, ETokenType.IDENTIFIER, ETokenType.RPAREN}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).group(1);

    public void execute() throws CheckException {
        List entities = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        for (ShallowEntity attribute : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.ATTRIBUTE)) {
            if (!attribute.getSubtype().equals("global variable") && !attribute.getSubtype().equals("attribute")) continue;
            this.checkTypeOfVariableDeclaration(attribute);
        }
        for (ShallowEntity method : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.METHOD)) {
            if (method.getSubtype().equals("constructor declaration") || method.getSubtype().equals("constructor")) {
                this.checkConstructor(method);
                continue;
            }
            if (!method.getSubtype().equals("function declaration")) continue;
            this.checkFunctionDeclaration(method);
        }
        for (ShallowEntity type : ShallowEntityTraversalUtils.listEntitiesOfType((Collection)entities, (EShallowEntityType)EShallowEntityType.TYPE)) {
            if (!type.getSubtype().equals("typedef")) continue;
            this.checkTypdef(type);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void checkTypdef(ShallowEntity typedef) {
        TokenPatternMatch match = TYPEDEF_PATTERN.findFirstMatch((List)typedef.ownStartTokens());
        if (this.checkTypedefReturnType(typedef, match)) {
            return;
        }
        this.checkTypedefParameters(typedef, match);
    }

    private void checkTypedefParameters(ShallowEntity entity, TokenPatternMatch match) {
        if (match == null || !match.hasGroup(1)) {
            return;
        }
        List typeTokens = match.groupTokens(1);
        typeTokens = TokenStreamUtils.removeAtFront((List)typeTokens, (ETokenType)ETokenType.LPAREN);
        typeTokens = TokenStreamUtils.removeAtEnd((List)typeTokens, (ETokenType)ETokenType.RPAREN);
        this.checkParameterTypes(entity, LanguageFeatureParser.CPP.splitVariableTokens(typeTokens));
    }

    private boolean checkTypedefReturnType(ShallowEntity entity, TokenPatternMatch match) {
        if (match == null || !match.hasGroup(0)) {
            return false;
        }
        List typeTokens = match.groupTokens(0);
        typeTokens = TokenStreamUtils.removeAtFront((List)typeTokens, (ETokenType)ETokenType.TYPEDEF);
        if ((typeTokens = TokenStreamUtils.removeAtEnd((List)typeTokens, (ETokenType)ETokenType.LPAREN)).isEmpty()) {
            this.buildFinding("Type specification missing: Missing return type for typedef `" + entity.getName() + "`", this.buildLocation().forEntity(entity)).createAndStore();
            return true;
        }
        return false;
    }

    private void checkFunctionDeclaration(ShallowEntity functionDeclaration) {
        List parameterTokens = LanguageFeatureParser.CPP.getSplitParameterTokens(functionDeclaration);
        this.checkParameterTypes(functionDeclaration, parameterTokens);
    }

    private void checkParameterTypes(ShallowEntity entity, List<List<IToken>> parameterTokensList) {
        for (List<IToken> parameterTokens : parameterTokensList) {
            if (!TypesShallBeExplicitlySpecifiedCheck.hasAtMostOneToken(parameterTokens) && !TypesShallBeExplicitlySpecifiedCheck.isStructOrEnumParameter(parameterTokens) && !TypesShallBeExplicitlySpecifiedCheck.isVoidOrEllipsis(parameterTokens) && this.checkType(parameterTokens, "Type specification missing: Missing parameter type for `" + entity.getName() + "`")) break;
        }
    }

    private static boolean hasAtMostOneToken(List<IToken> parameterTokens) {
        return parameterTokens.size() <= 1 || !TokenStreamUtils.endsWith(parameterTokens, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER});
    }

    private static boolean isStructOrEnumParameter(List<IToken> parameterTokens) {
        if (parameterTokens.size() > 1) {
            return EnumSet.of(ETokenType.STRUCT, ETokenType.ENUM).contains(parameterTokens.get(0).getType()) && TokenStreamUtils.endsWith(parameterTokens, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER});
        }
        return false;
    }

    private void checkConstructor(ShallowEntity constructor) {
        if (!LanguageFeatureParser.CPP.isCppMethod(constructor)) {
            this.buildFinding("Type specification missing: Missing return type for `" + constructor.getName() + "`", this.buildLocation().forTokens((List)constructor.ownStartTokens())).createAndStore();
        }
    }

    private void checkTypeOfVariableDeclaration(ShallowEntity typedef) {
        if (TypesShallBeExplicitlySpecifiedCheck.isStructOrUnionOrEnumVariable(typedef)) {
            return;
        }
        Object tokens = typedef.ownStartTokens();
        int offset = TokenStreamUtils.findFirstTopLevel((List)tokens, (ITokenMatcher)ITokenMatcher.anyOfType((ETokenType[])new ETokenType[]{ETokenType.EQ, ETokenType.COMMA}), List.of(ETokenType.LT, ETokenType.LBRACE), List.of(ETokenType.GT, ETokenType.RBRACE));
        if (offset != -1) {
            tokens = tokens.subList(0, offset);
        }
        this.checkType((List<IToken>)tokens, "Type specification missing: Missing declaration type for `" + typedef.getName() + "`");
    }

    private static boolean isStructOrUnionOrEnumVariable(ShallowEntity entity) {
        ShallowEntity previousEntity = ShallowEntityTraversalUtils.getPreviousEntity((ShallowEntity)entity);
        if (previousEntity == null || previousEntity == entity.getParent()) {
            return false;
        }
        return Set.of("struct", "union", "enum").contains(previousEntity.getSubtype()) && ((IToken)previousEntity.getAllTokensOfFile().get(previousEntity.getEndTokenIndex() - 1)).getType() != ETokenType.SEMICOLON;
    }

    private boolean checkType(List<IToken> typeTokens, String message) {
        if (TypesShallBeExplicitlySpecifiedCheck.isCppUnionTypeDeclaration(typeTokens)) {
            return false;
        }
        String type = (String)LanguageFeatureParser.CPP.getModifiersAndTypeFromTokens(typeTokens).getSecond();
        if (type == null) {
            this.buildFinding(message, this.buildLocation().forTokens(typeTokens)).createAndStore();
            return true;
        }
        return false;
    }

    private static boolean isCppUnionTypeDeclaration(List<IToken> typeTokens) {
        int unionIndex = TokenStreamUtils.findFirstTopLevel(typeTokens, (ITokenMatcher)ETokenType.UNION, List.of(ETokenType.LBRACE), List.of(ETokenType.RBRACE));
        if (unionIndex == -1) {
            return false;
        }
        return TokenStreamUtils.containsSequence(typeTokens, (int)unionIndex, (int)(unionIndex + 3), (ETokenType[])new ETokenType[]{ETokenType.UNION, ETokenType.IDENTIFIER, ETokenType.LBRACE});
    }

    private static boolean isVoidOrEllipsis(List<IToken> parameterTokens) {
        if (parameterTokens.size() == 1) {
            ETokenType type = parameterTokens.get(0).getType();
            return type == ETokenType.VOID || type == ETokenType.ELLIPSIS;
        }
        if (parameterTokens.size() > 1) {
            ETokenType type = parameterTokens.get(1).getType();
            return type == ETokenType.ELLIPSIS;
        }
        return false;
    }
}

