/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.preprocessor;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

@Check(id="cqse-include-filename-delimiter", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class IncludeFilenameDelimiterCheck
extends CheckImplementationBase {
    private List<IToken> tokens;

    public void execute() throws CheckException {
        this.tokens = this.context.getTokens(ECodeViewOption.FILTERED);
        List<IToken> preprocessedIncludeTokens = this.getPreprocessedIncludeTokens();
        for (IToken token : preprocessedIncludeTokens) {
            String includeFileName;
            String[] parts = token.getText().split("[^#\\s]\\s", 2);
            if (parts.length < 2 || (includeFileName = parts[1].trim()).matches("<[^>]*>") || includeFileName.matches("\"[^\"]*\"")) continue;
            this.buildFinding("Included header names should be delimited by `<...>` or `\"...\"`", this.buildLocation().forLine(token.getLineNumber() + 1)).createAndStore();
        }
    }

    private List<IToken> getPreprocessedIncludeTokens() {
        List<IToken> includeTokens = this.getTokensByType(ETokenType.PREPROCESSOR_INCLUDE);
        List<IToken> directiveTokens = this.getTokensByType(ETokenType.PREPROCESSOR_DIRECTIVE);
        includeTokens.addAll(IncludeFilenameDelimiterCheck.findAndPreprocessIncludeTokens(directiveTokens));
        return includeTokens;
    }

    private List<IToken> getTokensByType(ETokenType type) {
        return TokenStreamUtils.findAll(this.tokens, (ITokenMatcher)type).stream().map(this::mapIndexToToken).collect(Collectors.toList());
    }

    private IToken mapIndexToToken(int index) {
        return this.tokens.get(index);
    }

    private static List<IToken> findAndPreprocessIncludeTokens(List<IToken> directiveTokens) {
        List<IToken> defineTokens = IncludeFilenameDelimiterCheck.filterTokensByBeginning(directiveTokens, "#define");
        Map<String, String> macroMapping = IncludeFilenameDelimiterCheck.processDefineTokens(defineTokens);
        List<IToken> includeTokens = IncludeFilenameDelimiterCheck.filterTokensByBeginning(directiveTokens, "#include");
        return IncludeFilenameDelimiterCheck.applyMacros(includeTokens, macroMapping);
    }

    private static List<IToken> filterTokensByBeginning(List<IToken> directiveTokens, String prefix) {
        return directiveTokens.stream().filter(token -> token.getText().replaceAll("\\s", "").startsWith(prefix)).collect(Collectors.toList());
    }

    private static Map<String, String> processDefineTokens(List<IToken> defineTokens) {
        Hashtable<String, String> macroMapping = new Hashtable<String, String>();
        for (IToken token : defineTokens) {
            String[] parts = token.getText().split(" ", 3);
            if (parts.length != 3) continue;
            macroMapping.put(parts[1], parts[2].trim());
        }
        return macroMapping;
    }

    private static List<IToken> applyMacros(List<IToken> includeTokens, Map<String, String> macroMapping) {
        ArrayList<IToken> processedIncludeTokens = new ArrayList<IToken>();
        for (IToken token : includeTokens) {
            String[] wordsInToken = token.getText().split(" ");
            boolean getsConcatenated = wordsInToken.length > 2;
            StringBuilder processedFileName = new StringBuilder();
            for (int i = 1; i < wordsInToken.length; ++i) {
                String replacement = macroMapping.getOrDefault(wordsInToken[i], wordsInToken[i]);
                processedFileName.append(IncludeFilenameDelimiterCheck.removeDoubleQuotesIfNecessary(replacement, getsConcatenated));
            }
            if (processedFileName.isEmpty()) continue;
            processedIncludeTokens.add(token.newToken(ETokenType.PREPROCESSOR_INCLUDE, token.getOffset(), token.getLineNumber(), "#include " + String.valueOf(processedFileName), token.getOriginId()));
        }
        return processedIncludeTokens;
    }

    private static String removeDoubleQuotesIfNecessary(String replacement, boolean getsConcatenated) {
        if (getsConcatenated && replacement.startsWith("\"") && replacement.endsWith("\"")) {
            replacement = replacement.substring(1, replacement.length() - 1);
        }
        return replacement;
    }
}

