/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.cpp.misra.switches;

import eu.cqse.check.cpp.misra.switches.CppNoreturnMethodExtractorPhase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.SwitchStatementUtils;
import eu.cqse.check.framework.util.tokens.TokenUtils;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.IdentityHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Pattern;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-switch-clause-is-terminated-by-break-statement", languages={ELanguage.CPP, ELanguage.CPP_MS_CLI, ELanguage.C, ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, phases={CppNoreturnMethodExtractorPhase.class})
public class SwitchClauseIsTerminatedByBreakStatementCheck
extends CheckImplementationBase {
    @CheckOption(name="Ignore missing break statement in default cases of switch statements", description="If enabled, default cases of switch statements do not need a break if they are the last cases of the switch. However some valid MISRA findings will not be reported (the MISRA rule requires a break in each case including the default case, even if it is the last case).")
    private boolean ignoreMissingBreakStatementInDefaultCase = false;
    private static final List<String> KNOWN_EXIT_METHODS = Arrays.asList("abort", "exit", "_Exit", "quick_exit", "thrd_exit", "longjmp", "Q_FALLTHROUGH");
    private static final String FALSE_LITERALS_PATTERN_STRING = "0|false|not\"[^\"]*\"|!\"[^\"]*\"";
    private static final String FALSE_ANDAND_STRING_PATTERN_STRING = "(false|0)&&\"[^\"]*\"|\"[^\"]*\"&&(false|0)";
    private static final Pattern ASSERT_AS_EXIT_PATTERN = Pattern.compile("assert\\((0|false|not\"[^\"]*\"|!\"[^\"]*\"|(false|0)&&\"[^\"]*\"|\"[^\"]*\"&&(false|0))\\);");

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if (!"switch".equals(statement.getSubtype())) continue;
            this.processEntity(statement);
        }
    }

    protected ECodeViewOption getCodeViewOption() {
        return ECodeViewOption.FILTERED_PREPROCESSED;
    }

    private void processEntity(ShallowEntity entity) throws CheckException {
        if (SwitchClauseIsTerminatedByBreakStatementCheck.isPurelyMacroGenerated(entity)) {
            return;
        }
        Map<ShallowEntity, ShallowEntity> caseOrDefaultToLastStatementMapping = this.calculateLastChildByCaseOrDefaultEntity(entity);
        for (Map.Entry<ShallowEntity, ShallowEntity> caseOrDefault : caseOrDefaultToLastStatementMapping.entrySet()) {
            this.checkCase(caseOrDefault.getKey(), caseOrDefault.getValue());
        }
    }

    private static boolean isPurelyMacroGenerated(ShallowEntity switchEntity) {
        if (!TokenStreamUtils.startsWith((List)switchEntity.ownStartTokens(), (ETokenType[])new ETokenType[]{ETokenType.SWITCH, ETokenType.LPAREN, ETokenType.INTEGER_LITERAL, ETokenType.RPAREN})) {
            return false;
        }
        if (!"0".equals(((IToken)switchEntity.ownStartTokens().get(2)).getText())) {
            return false;
        }
        if (!switchEntity.ownStartTokens().stream().allMatch(TokenUtils::isMacroGenerated)) {
            return false;
        }
        Optional<ShallowEntity> defaultCase = SwitchClauseIsTerminatedByBreakStatementCheck.getDefaultCaseEntity(switchEntity);
        return defaultCase.isPresent() && defaultCase.get().ownTokens().stream().flatMap(Collection::stream).allMatch(TokenUtils::isMacroGenerated);
    }

    private void checkCase(ShallowEntity caseOrDefault, ShallowEntity lastEntity) throws CheckException {
        if (!this.shouldReportFinding(caseOrDefault, lastEntity, false)) {
            return;
        }
        Object inferredInformation = caseOrDefault.getSubtype();
        if (((String)inferredInformation).equals("case")) {
            inferredInformation = (String)inferredInformation + " " + caseOrDefault.getName();
        }
        this.buildFinding("`" + (String)inferredInformation + "` has to be terminated unconditionally", this.buildLocation().forLine(caseOrDefault.getStartLine())).createAndStore();
    }

    private boolean shouldReportFinding(ShallowEntity caseOrDefault, ShallowEntity lastEntity, boolean isNestedSwitch) throws CheckException {
        if (this.ignoreMissingBreakStatementInDefaultCase && caseOrDefault.getSubtype().equals("default")) {
            return false;
        }
        if (!lastEntity.getSubtype().equals("anonymous block")) {
            return this.shouldReportFindingGivenNonAnonymousBlock(caseOrDefault, lastEntity, isNestedSwitch);
        }
        UnmodifiableList childEntities = lastEntity.getChildren();
        if (childEntities.isEmpty()) {
            return false;
        }
        return this.shouldReportFindingGivenNonAnonymousBlock(caseOrDefault, (ShallowEntity)CollectionUtils.getLast((List)childEntities), isNestedSwitch);
    }

    private boolean shouldReportFindingGivenNonAnonymousBlock(ShallowEntity caseOrDefault, ShallowEntity lastEntity, boolean isNestedSwitch) throws CheckException {
        if (SwitchStatementUtils.isSwitch((ShallowEntity)lastEntity)) {
            return this.someControlPathIsNotTerminated(lastEntity);
        }
        if (SwitchClauseIsTerminatedByBreakStatementCheck.isDefaultAndEndsWithTerminatingAssert(caseOrDefault, lastEntity)) {
            return false;
        }
        if (this.context.getLanguage() == ELanguage.OBJECTIVE_C) {
            return !LanguageFeatureParser.OBJECTIVE_C.isUnconditionalSwitchExit(lastEntity, isNestedSwitch) && !SwitchStatementUtils.isFallThroughAttribute((ICheckContext)this.context, (ShallowEntity)caseOrDefault, (ShallowEntity)lastEntity);
        }
        return !LanguageFeatureParser.CPP.isUnconditionalSwitchExit(lastEntity, SwitchClauseIsTerminatedByBreakStatementCheck.determineAdditionalExitNames(this.context), isNestedSwitch) && !SwitchStatementUtils.isFallThroughAttribute((ICheckContext)this.context, (ShallowEntity)caseOrDefault, (ShallowEntity)lastEntity);
    }

    private boolean someControlPathIsNotTerminated(ShallowEntity switchStatement) throws CheckException {
        Map<ShallowEntity, ShallowEntity> caseOrDefaultToLastStatementMapping = this.calculateLastChildByCaseOrDefaultEntity(switchStatement);
        for (Map.Entry<ShallowEntity, ShallowEntity> entry : caseOrDefaultToLastStatementMapping.entrySet()) {
            if (!this.shouldReportFinding(switchStatement, entry.getValue(), true)) continue;
            return true;
        }
        return false;
    }

    private static boolean isDefaultAndEndsWithTerminatingAssert(ShallowEntity caseOrDefault, ShallowEntity lastEntity) {
        if ("default".equals(caseOrDefault.getSubtype()) && "assert".equals(lastEntity.getName())) {
            String assertAsString = TokenStreamTextUtils.concatTokenTexts((List)lastEntity.includedTokens());
            return ASSERT_AS_EXIT_PATTERN.matcher(assertAsString).matches();
        }
        return false;
    }

    static Set<String> determineAdditionalExitNames(ICheckContext context) {
        HashSet<String> additionalExitNames = new HashSet<String>(KNOWN_EXIT_METHODS);
        additionalExitNames.addAll(context.listAllPhaseValues(CppNoreturnMethodExtractorPhase.class));
        return additionalExitNames;
    }

    private Map<ShallowEntity, ShallowEntity> calculateLastChildByCaseOrDefaultEntity(ShallowEntity entity) {
        IdentityHashMap<ShallowEntity, ShallowEntity> mapping = new IdentityHashMap<ShallowEntity, ShallowEntity>();
        ShallowEntity currentCaseOrDefault = null;
        for (ShallowEntity shallowEntity : entity.getChildren()) {
            if (shallowEntity.getType() == EShallowEntityType.META && shallowEntity.getSubtype().equals("pragma directive")) continue;
            if (SwitchStatementUtils.isCaseOrDefault((ShallowEntity)shallowEntity)) {
                currentCaseOrDefault = shallowEntity;
                continue;
            }
            if (currentCaseOrDefault == null || shallowEntity.getSubtype().equals("empty statement") && mapping.containsKey(currentCaseOrDefault) && !SwitchStatementUtils.isFallThroughAttribute((ICheckContext)this.context, (ShallowEntity)currentCaseOrDefault, (ShallowEntity)shallowEntity)) continue;
            mapping.put(currentCaseOrDefault, shallowEntity);
        }
        return mapping;
    }

    private static Optional<ShallowEntity> getDefaultCaseEntity(ShallowEntity switchStatement) {
        for (ShallowEntity shallowEntity : switchStatement.getChildren()) {
            if (!SwitchStatementUtils.isDefault((ShallowEntity)shallowEntity)) continue;
            return Optional.of(shallowEntity);
        }
        return Optional.empty();
    }
}

