/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.hana_views;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.hana_views.HanaViewsCheckUtil;
import eu.cqse.check.xml.AttributeRegexCheckBase;
import java.util.regex.Pattern;

@Check(id="cqse-calculated-attributes-prefix", languages={ELanguage.HANA_VIEW})
public class CalculatedAttributesPrefixCheck
extends AttributeRegexCheckBase {
    private static final String CHECK_NAME = "Prefix of calculated attributes";
    @CheckOption(name="Prefix of calculated attributes - required prefix", description="Prefix required for calculated attributes.")
    private String prefix = "CA_";

    public CalculatedAttributesPrefixCheck() {
        super(HanaViewsCheckUtil.ELEMENTS_CALCULATED_ATTRIBUTE, "id");
    }

    @Override
    protected String getFindingsMessage() {
        return "Calculated attribute names must start with '" + this.prefix + "'";
    }

    @Override
    protected Pattern getPattern() {
        return CalculatedAttributesPrefixCheck.getPrefixPattern(this.prefix);
    }

    @Override
    protected boolean showPatternInFindingsMessage() {
        return false;
    }
}

