/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import com.fasterxml.jackson.annotation.JsonProperty;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.JavaMethodCallMatcher;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.clike.HardcodedParameterEvaluator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.resources.Resource;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S6437", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class HardCodedCredentialsShouldNotBeUsedCheck
extends CheckImplementationBase {
    private static final SetMap<String, SensitiveMethodInfo> METHODS_TO_CHECK_BY_NAMESPACE = new SetMap();
    private static final String SENSITIVE_METHODS_TSV_FILE = "HardCodedCredentialsShouldNotBeUsedCheck/sensitive-methods-signatures.tsv";

    private static @NonNull List<SensitiveMethodInfo> readMethodsTsv() {
        String tsvContent = Resource.of(HardCodedCredentialsShouldNotBeUsedCheck.class, (String)SENSITIVE_METHODS_TSV_FILE).getContent();
        ArrayList<SensitiveMethodInfo> methods = new ArrayList<SensitiveMethodInfo>();
        String[] lines = StringUtils.splitLines((String)tsvContent);
        for (int i = 0; i < lines.length; ++i) {
            String line = lines[i];
            if (i == 0 || line.trim().isEmpty()) continue;
            String[] parts = line.split("\t");
            List<String> parameterTypes = HardCodedCredentialsShouldNotBeUsedCheck.readTsvArray(parts[2]);
            List<Integer> indices = HardCodedCredentialsShouldNotBeUsedCheck.readTsvArray(parts[3]).stream().map(Integer::parseInt).toList();
            methods.add(new SensitiveMethodInfo(parts[0], parts[1], parameterTypes, indices));
        }
        return methods;
    }

    private static List<String> readTsvArray(String columnContent) {
        return Arrays.stream(StringUtils.stripSuffix((String)StringUtils.stripPrefix((String)columnContent, (String)"["), (String)"]").split(",")).map(String::trim).toList();
    }

    public void execute() throws CheckException {
        Set imports = LanguageFeatureParser.JAVA.getImportsAndFullNamespaceVariables((List)this.getRootChildren());
        UnmodifiableSet allNamespaces = METHODS_TO_CHECK_BY_NAMESPACE.getKeys();
        Set relevantImportsInFile = imports.stream().filter(importedNamespace -> allNamespaces.contains((Object)StringUtils.removeLastPart((String)StringUtils.stripSuffix((String)importedNamespace, (String)"*"), (char)'.'))).map(namespace -> StringUtils.removeLastPart((String)StringUtils.stripSuffix((String)namespace, (String)"*"), (char)'.')).collect(Collectors.toSet());
        if (relevantImportsInFile.isEmpty()) {
            return;
        }
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        for (String relevantImport : relevantImportsInFile) {
            for (SensitiveMethodInfo sensitiveMethodInfo : (Set)METHODS_TO_CHECK_BY_NAMESPACE.getCollectionOrEmpty((Object)relevantImport)) {
                for (JavaMethodCallMatcher.MethodCall methodCall : HardCodedCredentialsShouldNotBeUsedCheck.getMethodCallMatcher(sensitiveMethodInfo).find(this.context, typeResolver)) {
                    this.checkMethodCall(methodCall, sensitiveMethodInfo);
                }
            }
        }
    }

    private static JavaMethodCallMatcher getMethodCallMatcher(SensitiveMethodInfo sensitiveMethodInfo) {
        JavaMethodCallMatcher methodCallMatcher = JavaMethodCallMatcher.create().onTypes(new String[]{sensitiveMethodInfo.cls}).withParameterCount(sensitiveMethodInfo.args.size()).allowChaining(true);
        if (sensitiveMethodInfo.cls.endsWith("." + sensitiveMethodInfo.name)) {
            return methodCallMatcher.constructorsAndGetInstanceCalls();
        }
        return methodCallMatcher.withTargetMethodNames(new String[]{sensitiveMethodInfo.name});
    }

    private void checkMethodCall(JavaMethodCallMatcher.MethodCall methodCall, SensitiveMethodInfo methodInfo) throws CheckException {
        for (int index : methodInfo.indices) {
            HardcodedParameterEvaluator parameterEvaluator;
            if (index > methodCall.parameters().size() - 1 || !(parameterEvaluator = new HardcodedParameterEvaluator(methodCall.entity(), (List)methodCall.parameters().get(index), this.context.getTypeResolution(this.getCodeViewOption()))).isHardcodedExpression()) continue;
            this.buildFinding("Revoke and change this password, as it is compromised", this.buildLocation().forToken(methodCall.token())).createAndStore();
            return;
        }
    }

    static {
        List<SensitiveMethodInfo> sensitiveMethodInfos = HardCodedCredentialsShouldNotBeUsedCheck.readMethodsTsv();
        for (SensitiveMethodInfo methodInfo : sensitiveMethodInfos) {
            METHODS_TO_CHECK_BY_NAMESPACE.add((Object)StringUtils.removeLastPart((String)methodInfo.cls, (char)'.'), (Object)methodInfo);
        }
    }

    record SensitiveMethodInfo(@JsonProperty(value="cls") String cls, @JsonProperty(value="name") String name, @JsonProperty(value="args") List<String> args, @JsonProperty(value="indices") List<Integer> indices) {
        @Override
        public int hashCode() {
            return Objects.hash(this.cls, this.name, this.indices);
        }

        @Override
        public boolean equals(Object obj) {
            if (obj instanceof SensitiveMethodInfo) {
                SensitiveMethodInfo other = (SensitiveMethodInfo)obj;
                return Objects.equals(this.cls, other.cls) && Objects.equals(this.name, other.name) && this.indices.size() == other.indices.size() && CollectionUtils.intersectionSet(this.indices, (Collection[])new Collection[]{other.indices}).size() == other.indices.size();
            }
            return false;
        }
    }
}

