/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.List;
import org.conqat.lib.commons.markup.MarkupUtils;

@Check(id="cqse-parameters-of-abstract-methods-must-not-be-final", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ParametersOfAbstractMethodsMustNotBeFinalCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List abstractSyntaxTree = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)abstractSyntaxTree, (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (!"abstract".equals(method.getSubtype())) continue;
            this.processEntity(method);
        }
    }

    private void processEntity(ShallowEntity method) {
        for (IToken token : method.ownStartTokens()) {
            if (token.getType() != ETokenType.FINAL) continue;
            this.buildFinding(ParametersOfAbstractMethodsMustNotBeFinalCheck.getFindingMessage(method), this.buildLocation().forToken(token)).createAndStore();
        }
    }

    private static String getFindingMessage(ShallowEntity entity) {
        return "Parameters of abstract method " + MarkupUtils.formatAsSourceCode((String)entity.getName()) + " should not be `final`";
    }
}

