/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.util.ShallowParsingUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.java.EIdentifierType;
import eu.cqse.check.java.IdentifierData;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.compress.utils.Sets;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.collections.PairList;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-same-name-different-casing", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class SameNameDifferentCasingCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List<IdentifierData> identifiers = this.findAllIdentifiers();
        this.findClashesAmongCheckedTypes(identifiers, EnumSet.of(EIdentifierType.CLASS));
        this.findClashesAmongCheckedTypes(identifiers, EnumSet.of(EIdentifierType.CONSTANT));
        this.findClashesAmongCheckedTypes(identifiers, EnumSet.of(EIdentifierType.FIELD, EIdentifierType.LOCAL_VARIABLE, EIdentifierType.PARAMETER, EIdentifierType.METHOD));
    }

    private List<IdentifierData> findAllIdentifiers() throws CheckException {
        ArrayList<IdentifierData> identifiers = new ArrayList<IdentifierData>();
        identifiers.addAll(SameNameDifferentCasingCheck.extractIdentifiers(this.select("//TYPE"), EIdentifierType.CLASS));
        List localVariables = this.select("//STATEMENT[count(node())=0 and subtype('local variable')]");
        identifiers.addAll(SameNameDifferentCasingCheck.extractIdentifiers(localVariables, EIdentifierType.LOCAL_VARIABLE));
        for (ShallowEntity field : this.select("//ATTRIBUTE[subtype('attribute')]")) {
            if (StringUtils.isEmpty((String)field.getName())) continue;
            if (LanguageFeatureParser.JAVA.isConstant(field)) {
                identifiers.add(new IdentifierData(EIdentifierType.CONSTANT, field.getName(), field));
                continue;
            }
            identifiers.add(new IdentifierData(EIdentifierType.FIELD, field.getName(), field));
        }
        for (ShallowEntity method : this.select("//METHOD")) {
            if (!StringUtils.isEmpty((String)method.getName()) && !method.getSubtype().equals("constructor")) {
                identifiers.add(new IdentifierData(EIdentifierType.METHOD, method.getName(), method));
            }
            List parameterTokens = ShallowParsingUtils.extractParameterNameTokens((ShallowEntity)method);
            for (IToken parameterToken : parameterTokens) {
                identifiers.add(new IdentifierData(EIdentifierType.PARAMETER, parameterToken.getText(), method));
            }
        }
        return identifiers;
    }

    private static List<IdentifierData> extractIdentifiers(List<ShallowEntity> entities, EIdentifierType type) {
        return CollectionUtils.filterAndMap(entities, entity -> !StringUtils.isEmpty((String)entity.getName()), entity -> new IdentifierData(type, entity.getName(), (ShallowEntity)entity));
    }

    private void findClashesAmongCheckedTypes(List<IdentifierData> identifiers, Set<EIdentifierType> checkedTypes) throws CheckException {
        HashSet<Pair> identifierPairsWithFindings = new HashSet<Pair>();
        Map<String, List<IdentifierData>> identifiersByCanonicalIdentifier = identifiers.stream().filter(identifier -> checkedTypes.contains((Object)identifier.getType())).collect(Collectors.groupingBy(identifier -> identifier.getName().toLowerCase()));
        for (List<IdentifierData> identifiersWithSameCanonicalization : identifiersByCanonicalIdentifier.values()) {
            List<IdentifierData> orderedIdentifiers = identifiersWithSameCanonicalization.stream().sorted(Comparator.comparing(IdentifierData::getType).thenComparing(IdentifierData::getName)).collect(Collectors.toList());
            for (IdentifierData identifier2 : orderedIdentifiers) {
                IdentifierData clashingIdentifier;
                Optional<IdentifierData> identifierWithDifferentCase = SameNameDifferentCasingCheck.findPotentialClash(orderedIdentifiers, identifier2);
                if (identifierWithDifferentCase.isEmpty() || identifierPairsWithFindings.contains(Pair.createPair((Object)identifier2, (Object)(clashingIdentifier = identifierWithDifferentCase.get()))) || identifierPairsWithFindings.contains(Pair.createPair((Object)clashingIdentifier, (Object)identifier2))) continue;
                this.createFinding(identifier2, clashingIdentifier);
                identifierPairsWithFindings.add(Pair.createPair((Object)identifier2, (Object)clashingIdentifier));
            }
        }
    }

    private static Optional<IdentifierData> findPotentialClash(List<IdentifierData> otherIdentifiers, IdentifierData currentIdentifier) {
        return otherIdentifiers.stream().filter(potentialClash -> !potentialClash.getName().equals(currentIdentifier.getName())).findAny();
    }

    private void createFinding(IdentifierData referenceData, IdentifierData otherData) throws CheckException {
        PairList pairList = new PairList();
        IToken referenceDataToken = SameNameDifferentCasingCheck.getIdentifierToken(referenceData);
        pairList.add((Object)referenceDataToken, (Object)referenceDataToken);
        IToken otherDataToken = SameNameDifferentCasingCheck.getIdentifierToken(otherData);
        pairList.add((Object)otherDataToken, (Object)otherDataToken);
        Object referenceDataName = referenceData.getName();
        Object otherDataName = otherData.getName();
        String referenceDataClassName = SameNameDifferentCasingCheck.getClassName(referenceData.getEntity());
        String otherDataClassName = SameNameDifferentCasingCheck.getClassName(otherData.getEntity());
        if (!referenceDataClassName.equals(otherDataClassName) && !referenceDataClassName.equals(referenceDataName)) {
            referenceDataName = referenceDataClassName + "#" + referenceData.getName();
            otherDataName = otherDataClassName + "#" + otherData.getName();
        }
        this.createFindingForSiblings(StringUtils.capitalize((String)referenceData.getType().getDescription()) + " " + (String)referenceDataName + " differs only in casing from " + otherData.getType().getDescription().toLowerCase() + " " + (String)otherDataName, pairList, null);
    }

    private static String getClassName(ShallowEntity entity) {
        if (entity.getType() == EShallowEntityType.TYPE && Sets.newHashSet((Object[])new String[]{"class", "interface", "@interface", "enum", "record"}).contains(entity.getSubtype())) {
            return entity.getName();
        }
        CCSMAssert.isNotNull((Object)entity.getParent(), () -> "Could not determine enclosing type of entity " + entity.getName() + " in line " + entity.getStartLine());
        return SameNameDifferentCasingCheck.getClassName(entity.getParent());
    }

    private static IToken getIdentifierToken(IdentifierData identifierData) {
        UnmodifiableList startTokens = identifierData.getEntity().ownStartTokens();
        if (startTokens.isEmpty()) {
            return (IToken)identifierData.getEntity().includedTokens().get(0);
        }
        return startTokens.stream().filter(token -> token.getType() == ETokenType.IDENTIFIER && identifierData.getName().equals(token.getText())).findFirst().orElse((IToken)startTokens.get(0));
    }
}

