/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.comment;

import eu.cqse.check.java.comment.EJavaDocParameter;
import eu.cqse.check.java.comment.IJavaDocTag;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public enum EJavaDocBlockTag implements IJavaDocTag
{
    AUTHOR("author", EJavaDocParameter.TEXT_PARAMETER),
    DEPRECATED("deprecated", EJavaDocParameter.TEXT_PARAMETER),
    EXCEPTION("exception", EJavaDocParameter.CLASS_REFERENCE_PARAMETER, EJavaDocParameter.OPTIONAL_TEXT_PARAMETER),
    PARAM("param", EJavaDocParameter.PARAMETER_PARAMETER, EJavaDocParameter.TEXT_PARAMETER),
    RETURN("return", EJavaDocParameter.TEXT_PARAMETER),
    SEE("see", EJavaDocParameter.REFERENCE_PARAMETER, EJavaDocParameter.OPTIONAL_TEXT_PARAMETER),
    SINCE("since", EJavaDocParameter.TEXT_PARAMETER),
    THROWS("throws", EJavaDocParameter.CLASS_REFERENCE_PARAMETER, EJavaDocParameter.OPTIONAL_TEXT_PARAMETER),
    VERSION("version", EJavaDocParameter.TEXT_PARAMETER);

    private final String tagName;
    private final EJavaDocParameter[] parameters;

    private EJavaDocBlockTag(String tagName, EJavaDocParameter ... parameters) {
        this.tagName = tagName;
        this.parameters = parameters;
    }

    @Override
    public String getName() {
        return "@" + this.tagName;
    }

    @Override
    public List<EJavaDocParameter> getParameters() {
        return Arrays.asList(this.parameters);
    }

    public String toString() {
        return String.format("`%s %s`", this.getName(), Arrays.stream(this.parameters).map(EJavaDocParameter::toString).collect(Collectors.joining(" ")));
    }
}

