/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.comment;

import eu.cqse.check.base.CommentCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.phase.ECodeViewOption;
import eu.cqse.check.framework.matcher.ITokenMatcher;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.scanner.LanguageProperties;
import eu.cqse.check.framework.scanner.ScannerUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.java.comment.EJavaDocBlockTag;
import eu.cqse.check.java.comment.EJavaDocInlineTag;
import eu.cqse.check.java.comment.EJavaDocParameter;
import eu.cqse.check.java.comment.IJavaDocTag;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="cqse-java-doc-tag-completeness", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class JavaDocTagCompletenessCheck
extends CommentCheckBase {
    private static final Map<String, IJavaDocTag> ALL_TAGS_BY_NAME = new HashMap<String, IJavaDocTag>();

    protected void processComment(IToken completeComment, int startLine, int endLine) throws CheckException {
        if (completeComment.getType() != ETokenType.DOCUMENTATION_COMMENT) {
            return;
        }
        Optional<ShallowEntity> commentedEntity = this.getCommentedEntity(completeComment, this.context.getTokens(ECodeViewOption.FILTERED_PREPROCESSED));
        if (commentedEntity.isEmpty()) {
            return;
        }
        List commentTokens = ScannerUtils.getTokens((String)LanguageProperties.of((ELanguage)this.context.getLanguage()).getCommentContent(completeComment.getText()), (ELanguage)ELanguage.JAVADOC, (String)this.context.getUniformPath());
        this.checkComment(completeComment, new LinkedList<IToken>(commentTokens), commentedEntity.get());
    }

    private void checkComment(IToken completeComment, List<IToken> commentTokens, ShallowEntity relatedEntity) {
        SetMap<IToken, String> findingsByComment = JavaDocTagCompletenessCheck.collectFindings(completeComment, commentTokens, relatedEntity);
        for (Map.Entry entry : findingsByComment) {
            IToken comment = (IToken)entry.getKey();
            Set findings = (Set)entry.getValue();
            this.createJavaDocFinding(StringUtils.concat((Iterable)findings, (String)"\n"), comment);
        }
    }

    private static SetMap<IToken, String> collectFindings(IToken completeComment, List<IToken> commentTokens, ShallowEntity relatedEntity) {
        SetMap findingsByComment = new SetMap();
        while (!commentTokens.isEmpty()) {
            Optional<IJavaDocTag> optionalJavaDocTag;
            IToken token = commentTokens.removeFirst();
            if (!JavaDocTagCompletenessCheck.isJavaDocTag(token) || (optionalJavaDocTag = JavaDocTagCompletenessCheck.getByTagName(token)).isEmpty()) continue;
            IJavaDocTag javaDocTag = optionalJavaDocTag.get();
            int endIndex = JavaDocTagCompletenessCheck.computeEndIndex(token, commentTokens);
            if (endIndex == -1) {
                findingsByComment.add((Object)completeComment, (Object)("`" + javaDocTag.getName() + "` - Unterminated inline tag"));
                continue;
            }
            List<IToken> tagTokens = commentTokens.subList(0, endIndex);
            commentTokens = commentTokens.subList(tagTokens.size(), commentTokens.size());
            Optional<String> finding = JavaDocTagCompletenessCheck.createFindingMessage(token, tagTokens, relatedEntity);
            finding.ifPresent(s -> findingsByComment.add((Object)completeComment, (Object)("`" + javaDocTag.getName() + "` - " + s)));
        }
        return findingsByComment;
    }

    private void createJavaDocFinding(String findingMessage, IToken completeComment) {
        this.buildFinding("Incorrect JavaDoc Tags: " + findingMessage, this.buildLocation().forToken(completeComment)).createAndStore();
    }

    private Optional<ShallowEntity> getCommentedEntity(IToken commentToken, List<IToken> filteredPreprocessedTokens) throws CheckException {
        int index = filteredPreprocessedTokens.indexOf(commentToken) + 1;
        if (index == filteredPreprocessedTokens.size()) {
            return Optional.empty();
        }
        IToken nextToken = filteredPreprocessedTokens.get(index);
        return ShallowEntityTraversalUtils.findContainingEntityDepthFirst((IToken)nextToken, (List)this.context.getAbstractSyntaxTree(ECodeViewOption.FILTERED_PREPROCESSED));
    }

    private static Optional<IJavaDocTag> getByTagName(IToken token) {
        return Optional.ofNullable(ALL_TAGS_BY_NAME.get(token.getText()));
    }

    private static boolean isJavaDocTag(IToken token) {
        return EnumSet.of(ETokenType.JAVADOC_TAG, ETokenType.JAVADOC_INLINE_TAG).contains(token.getType());
    }

    private static int computeEndIndex(IToken tagToken, List<IToken> commentTokens) {
        if (tagToken.getType() == ETokenType.JAVADOC_INLINE_TAG) {
            return TokenStreamUtils.findMatchingClosingToken(commentTokens, (int)0, EJavaDocParameter.OPENING_TOKEN_TYPES, EJavaDocParameter.CLOSING_TOKEN_TYPES);
        }
        int index = TokenStreamUtils.firstTokenMatching(commentTokens, (int)0, (ITokenMatcher)ETokenType.JAVADOC_TAG);
        if (index == -1) {
            return commentTokens.size();
        }
        return index;
    }

    private static Optional<String> createFindingMessage(IToken token, List<IToken> commentTokens, ShallowEntity relatedEntity) {
        int nextInlineTag;
        if (token.getType() == ETokenType.JAVADOC_INLINE_TAG && (nextInlineTag = TokenStreamUtils.firstTokenMatching(commentTokens, (int)0, (ITokenMatcher)ETokenType.JAVADOC_INLINE_TAG)) != -1) {
            return Optional.of("Nesting inline JavaDoc tags");
        }
        Optional<IJavaDocTag> optionalJavaDocTag = JavaDocTagCompletenessCheck.getByTagName(token);
        if (optionalJavaDocTag.isEmpty()) {
            return Optional.empty();
        }
        IJavaDocTag javaDocTag = optionalJavaDocTag.get();
        if (javaDocTag == EJavaDocBlockTag.RETURN) {
            if (relatedEntity.getType() != EShallowEntityType.METHOD) {
                return Optional.of("Unnecessary " + javaDocTag.getName() + " JavaDoc tag for non-method class element '" + relatedEntity.getName() + "'");
            }
            if (LanguageFeatureParser.JAVA.hasVoidReturnType(relatedEntity)) {
                return Optional.of("Unnecessary " + javaDocTag.getName() + " JavaDoc tag for the methods that has a signature '" + ETokenType.VOID.toString().toLowerCase() + "'");
            }
        }
        if (JavaDocTagCompletenessCheck.conformsToExpectedPattern(javaDocTag, commentTokens, relatedEntity)) {
            return Optional.empty();
        }
        if (javaDocTag == EJavaDocBlockTag.PARAM && JavaDocTagCompletenessCheck.isValidParamSyntax(commentTokens)) {
            return Optional.of("Parameter " + commentTokens.getFirst().getText() + " is not declared");
        }
        return Optional.of("Pattern expected but not observed: " + String.valueOf(javaDocTag));
    }

    private static boolean conformsToExpectedPattern(IJavaDocTag tag, List<IToken> tagTokens, ShallowEntity relatedEntity) {
        List<EJavaDocParameter> parameters = tag.getParameters();
        if (parameters.isEmpty()) {
            return tagTokens.isEmpty();
        }
        if (JavaDocTagCompletenessCheck.allOptional(parameters) && tagTokens.isEmpty()) {
            return true;
        }
        TokenPattern pattern = TokenPattern.of().beginningOfStream();
        for (EJavaDocParameter parameter : parameters) {
            pattern.repeated(new Object[]{ETokenType.EOL}).sequence(new Object[]{parameter.getPattern(relatedEntity)});
        }
        pattern.repeated(new Object[]{ETokenType.EOL}).endOfStream();
        return pattern.matchesAnywhere(tagTokens);
    }

    private static boolean allOptional(List<EJavaDocParameter> parameters) {
        for (EJavaDocParameter parameter : parameters) {
            if (parameter.isOptional()) continue;
            return false;
        }
        return true;
    }

    private static boolean isValidParamSyntax(List<IToken> commentTokens) {
        return TokenStreamUtils.hasTokenTypeSequence(commentTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.WORD, ETokenType.WORD}) || TokenStreamUtils.hasTokenTypeSequence(commentTokens, (int)0, (ETokenType[])new ETokenType[]{ETokenType.WORD, ETokenType.EOL, ETokenType.WORD});
    }

    static {
        for (EJavaDocBlockTag eJavaDocBlockTag : EJavaDocBlockTag.values()) {
            ALL_TAGS_BY_NAME.put(eJavaDocBlockTag.getName(), eJavaDocBlockTag);
        }
        for (Enum enum_ : EJavaDocInlineTag.values()) {
            ALL_TAGS_BY_NAME.put("{" + enum_.getName(), (IJavaDocTag)((Object)enum_));
        }
    }
}

