/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.util.CLikeLanguageFeatureParserBase;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.java.spring.SpringChecksUtils;
import eu.cqse.check.java.spring.TypesWithSpringScopeExtractorPhase;
import java.util.Collection;
import java.util.List;

@Check(id="java:S6838", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class DirectBeanMethodInvocationWithoutProxyCheck
extends CheckImplementationBase {
    private static final TokenPattern PROXY_BEAN_METHODS_SET_TO_FALSE_PATTERN = TokenPattern.of().tokenTypeAndText(ETokenType.IDENTIFIER, "proxyBeanMethods").sequence(new Object[]{ETokenType.EQ}).tokenTypeAndText(ETokenType.BOOLEAN_LITERAL, "false");
    private static final String MESSAGE = "Replace this bean method invocation with a dependency injection";
    private static final int METHOD_CALL_GROUP = 0;

    public void execute() throws CheckException {
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.TYPE).forEach(this::checkType);
    }

    private void checkType(ShallowEntity type) {
        if (!DirectBeanMethodInvocationWithoutProxyCheck.hasConfigurationAnnotationWithProxyBeanMethodsSetToFalse(type)) {
            return;
        }
        List<ShallowEntity> beanMethods = type.getChildren().stream().filter(SpringChecksUtils::isBeanMethod).toList();
        if (beanMethods.isEmpty()) {
            return;
        }
        TokenPattern methodInvocationPattern = DirectBeanMethodInvocationWithoutProxyCheck.buildMethodInvocationsPattern(beanMethods);
        beanMethods.forEach(method -> this.checkMethod((ShallowEntity)method, methodInvocationPattern));
    }

    private static boolean hasConfigurationAnnotationWithProxyBeanMethodsSetToFalse(ShallowEntity type) {
        return CLikeLanguageFeatureParserBase.getAnnotations((ShallowEntity)type).stream().filter(annotation -> JavaLanguageFeatureParser.isSpecificAnnotation((ShallowEntity)annotation, SpringChecksUtils.CONFIGURATION_ANNOTATIONS)).findFirst().filter(entity -> PROXY_BEAN_METHODS_SET_TO_FALSE_PATTERN.matchesAnywhere((List)entity.ownStartTokens())).isPresent();
    }

    private static TokenPattern buildMethodInvocationsPattern(List<ShallowEntity> beanMethods) {
        Object[] methodNamesPatterns = beanMethods.stream().filter(method -> SpringChecksUtils.getScopeOfBean(method) != TypesWithSpringScopeExtractorPhase.SpringScope.PROTOTYPE).map(method -> TokenPattern.of().tokenTypeAndText(ETokenType.IDENTIFIER, method.getName())).toArray(TokenPattern[]::new);
        return TokenPattern.of().sequence(new Object[]{TokenPattern.of().alternative(new Object[]{TokenPattern.of().sequence(new Object[]{ETokenType.THIS, ETokenType.DOT}), TokenPattern.of().notPrecededBy((Object)ETokenType.DOT)}).alternative(methodNamesPatterns).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false)}).group(0);
    }

    private void checkMethod(ShallowEntity method, TokenPattern pattern) {
        List methodBodyTokens = method.getChildren().stream().flatMap(child -> child.includedTokens().stream()).toList();
        for (TokenPatternMatch match : pattern.findNonOverlappingMatches(methodBodyTokens)) {
            this.buildFinding(MESSAGE, this.buildLocation().forTokens(match.groupTokens(0))).createAndStore();
        }
    }
}

