/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.spring;

import com.google.common.collect.Sets;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.LanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.java.spring.TypesWithSpringScopeExtractorPhase;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jspecify.annotations.Nullable;

public final class SpringChecksUtils {
    private static final Set<String> ASYNC_ANNOTATIONS = Set.of("Async", "org.springframework.scheduling.annotation.Async");
    public static final Set<String> AUTOWIRE_ANNOTATIONS = Set.of("Autowired", "org.springframework.beans.factory.annotation.Autowired");
    public static final Set<String> CONFIGURATION_ANNOTATIONS = Set.of("org.springframework.context.annotation.Configuration", "Configuration");
    public static final Set<String> BEAN_ANNOTATIONS = Set.of("org.springframework.context.annotation.Bean", "Bean");
    private static final Set<String> SCOPE_ANNOTATIONS = Set.of("org.springframework.context.annotation.Scope", "Scope");
    public static final Set<String> QUALIFIER_ANNOTATIONS = Set.of("org.springframework.beans.factory.annotation.Qualifier", "Qualifier");
    public static final Set<String> INJECTION_ANNOTATIONS = Sets.union(AUTOWIRE_ANNOTATIONS, Set.of("Inject", "javax.inject.Inject", "jakarta.inject.Inject"));
    private static final String SPRING_IMPORT_PREFIX = "org.springframework";
    private static final TokenPattern SCOPE_VALUE_PATTERN = SpringChecksUtils.createScopeValuePattern();
    private static final int SCOPE_VALUE_GROUP = 0;

    private SpringChecksUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isAsyncMethod(ShallowEntity method) {
        if (method.getType() != EShallowEntityType.METHOD) return false;
        if (!JavaLanguageFeatureParser.hasAnnotation((ShallowEntity)method, ASYNC_ANNOTATIONS)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isBeanMethod(ShallowEntity method) {
        if (method.getType() != EShallowEntityType.METHOD) return false;
        if (!JavaLanguageFeatureParser.hasAnnotation((ShallowEntity)method, BEAN_ANNOTATIONS)) return false;
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static boolean isConfigurationClass(@Nullable ShallowEntity type) {
        if (type == null) return false;
        if (type.getType() != EShallowEntityType.TYPE) return false;
        if (!JavaLanguageFeatureParser.hasAnnotation((ShallowEntity)type, CONFIGURATION_ANNOTATIONS)) return false;
        return true;
    }

    public static TypesWithSpringScopeExtractorPhase.SpringScope getScopeOfBean(ShallowEntity bean) {
        Optional<ShallowEntity> maybeAnnotation = JavaLanguageFeatureParser.getAnnotations((ShallowEntity)bean).stream().filter(annotation -> JavaLanguageFeatureParser.isSpecificAnnotation((ShallowEntity)annotation, SCOPE_ANNOTATIONS)).findFirst();
        return maybeAnnotation.map(SpringChecksUtils::extractScope).orElse(TypesWithSpringScopeExtractorPhase.SpringScope.SINGLETON);
    }

    private static TypesWithSpringScopeExtractorPhase.SpringScope extractScope(ShallowEntity scopeAnnotation) {
        TokenPatternMatch match = SCOPE_VALUE_PATTERN.findFirstMatch((List)scopeAnnotation.ownStartTokens());
        if (match == null) {
            return TypesWithSpringScopeExtractorPhase.SpringScope.SINGLETON;
        }
        IToken last = (IToken)match.groupTokens(0).getLast();
        for (TypesWithSpringScopeExtractorPhase.SpringScope value : TypesWithSpringScopeExtractorPhase.SpringScope.values()) {
            if (!StringUtils.containsIgnoreCase((String)last.getText(), (String)value.name())) continue;
            return value;
        }
        return TypesWithSpringScopeExtractorPhase.SpringScope.CUSTOM;
    }

    private static TokenPattern createScopeValuePattern() {
        TokenPattern identifierPattern = new TokenPattern().repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER}).group(0);
        TokenPattern stringLiteralPattern = new TokenPattern().sequence(new Object[]{ETokenType.STRING_LITERAL}).group(0);
        TokenPattern valuePattern = new TokenPattern().alternative(new Object[]{stringLiteralPattern, identifierPattern});
        TokenPattern oneAnnotationParameterPattern = new TokenPattern().sequence(new Object[]{ETokenType.LPAREN}).sequence(new Object[]{valuePattern}).sequence(new Object[]{ETokenType.RPAREN});
        TokenPattern valueEqualsPattern = new TokenPattern().alternative(new Object[]{new TokenPattern().tokenTypeAndText(ETokenType.IDENTIFIER, "value"), new TokenPattern().tokenTypeAndText(ETokenType.IDENTIFIER, "scopeName")}).sequence(new Object[]{ETokenType.EQ}).sequence(new Object[]{valuePattern});
        return new TokenPattern().alternative(new Object[]{oneAnnotationParameterPattern, valueEqualsPattern});
    }

    public static boolean containsNoSpringImport(ShallowEntity rootEntity) {
        return LanguageFeatureParser.JAVA.getImportsByPrefix((List)rootEntity.getChildren(), new String[]{SPRING_IMPORT_PREFIX}).isEmpty();
    }
}

