/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.tests;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.ECheckTarget;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.java.JavaImportSensitiveTypeResolver;
import eu.cqse.check.framework.util.EJavaTestFramework;
import eu.cqse.check.framework.util.JavaLanguageFeatureParser;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import eu.cqse.check.java.tests.AssertJUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.string.StringUtils;

@Check(id="java:S5853", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE}, target={ECheckTarget.TEST_CODE})
public class ChainedAssertJAssertionsCheck
extends CheckImplementationBase {
    private static final String FINDING_MESSAGE = "Join these multiple assertions subject to one assertion chain";
    private static final TokenPattern CHAINED_METHOD_CALLS_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.RPAREN, ETokenType.DOT, ETokenType.IDENTIFIER}).group(0).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, true).group(1);
    private static final TokenPattern ASSERTION_CALL_PATTERN = new TokenPattern().repeated(new Object[]{ETokenType.IDENTIFIER, ETokenType.DOT}).group(0).sequence(new Object[]{ETokenType.IDENTIFIER}).group(1).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).group(2).sequence(new Object[]{ETokenType.DOT}).sequence(new Object[]{ETokenType.IDENTIFIER});

    public void execute() throws CheckException {
        JavaImportSensitiveTypeResolver typeResolver = new JavaImportSensitiveTypeResolver(this.context.getRootEntity(this.getCodeViewOption()));
        List ast = this.context.getAbstractSyntaxTree(this.getCodeViewOption());
        boolean hasAssertJImport = EJavaTestFramework.ASSERT_J.getAssertionTypes().stream().anyMatch(arg_0 -> ((JavaImportSensitiveTypeResolver)typeResolver).isImported(arg_0));
        boolean hasStaticAssertJImport = typeResolver.getStaticImports().stream().anyMatch(staticImport -> staticImport.startsWith(EJavaTestFramework.ASSERT_J.getNamespacePrefix()));
        List methods = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)ast, (EShallowEntityType)EShallowEntityType.METHOD);
        for (ShallowEntity method : methods) {
            if (ChainedAssertJAssertionsCheck.skipMethod(method)) continue;
            this.analyzeTestMethods(method, hasAssertJImport, hasStaticAssertJImport);
        }
    }

    private static boolean skipMethod(ShallowEntity method) {
        if ("lambda".equals(method.getSubtype())) {
            return true;
        }
        return !JavaLanguageFeatureParser.isTestMethod((ShallowEntity)method);
    }

    private void analyzeTestMethods(ShallowEntity method, boolean hasAssertJImport, boolean hasStaticAssertJImport) {
        String lastVariable = "";
        for (ShallowEntity statement : ShallowEntityTraversalUtils.listEntitiesOfType(List.of(method), (EShallowEntityType)EShallowEntityType.STATEMENT)) {
            List<String> variables = ChainedAssertJAssertionsCheck.getAssertedObjects(statement, hasAssertJImport, hasStaticAssertJImport);
            if (variables.size() != 1) {
                lastVariable = "";
                continue;
            }
            String currentVariable = variables.getFirst();
            if (currentVariable.equals(lastVariable) && !currentVariable.isEmpty()) {
                this.buildFinding(FINDING_MESSAGE, this.buildLocation().forEntity(statement)).createAndStore();
            }
            lastVariable = currentVariable;
        }
    }

    private static boolean containsOnlyAssertions(List<IToken> tokens) {
        List methodCalls = CHAINED_METHOD_CALLS_PATTERN.findAll(tokens);
        if (methodCalls.isEmpty()) {
            return false;
        }
        for (TokenPatternMatch chainedCall : methodCalls) {
            String methodCall = ((IToken)chainedCall.groupTokens(0).get(2)).getText();
            if (AssertJUtils.isFluentAssertionMethodName(methodCall) || AssertJUtils.isAssertionDescriptionMethod(methodCall)) continue;
            return false;
        }
        return true;
    }

    private static List<String> getAssertedObjects(ShallowEntity statement, boolean hasAssertJImport, boolean hasStaticAssertJImport) {
        ArrayList<String> assertedObjects = new ArrayList<String>();
        UnmodifiableList tokens = statement.ownStartTokens();
        boolean containsOnlyAssertions = ChainedAssertJAssertionsCheck.containsOnlyAssertions((List<IToken>)tokens);
        if (!containsOnlyAssertions) {
            return assertedObjects;
        }
        List matches = ASSERTION_CALL_PATTERN.findNonOverlappingMatches((List)tokens);
        for (TokenPatternMatch match : matches) {
            Optional<String> assertedObject = ChainedAssertJAssertionsCheck.getAssertedObject((List<IToken>)tokens, hasAssertJImport, hasStaticAssertJImport, match);
            assertedObject.ifPresent(assertedObjects::add);
        }
        return assertedObjects;
    }

    private static Optional<String> getAssertedObject(List<IToken> tokens, boolean hasAssertJImport, boolean hasStaticAssertJImport, TokenPatternMatch match) {
        List<IToken> assertedTokens = ChainedAssertJAssertionsCheck.getAssertionCallParameters(tokens, match);
        List methodCall = match.groupTokens(1);
        String methodCallName = ((IToken)methodCall.getFirst()).getText();
        if (!AssertJUtils.isStartAssertionMethodName(methodCallName) || ChainedAssertJAssertionsCheck.assertedObjectContainsMethodCall(assertedTokens)) {
            return Optional.empty();
        }
        String variable = TokenStreamTextUtils.concatTokenTexts(assertedTokens);
        String typeName = TokenStreamTextUtils.concatTokenTexts((List)match.groupTokens(0));
        if (typeName.isEmpty()) {
            if (hasStaticAssertJImport) {
                return Optional.of(variable);
            }
            return Optional.empty();
        }
        if ((typeName = StringUtils.stripSuffix((String)typeName, (String)".")).contains(".") ? EJavaTestFramework.ASSERT_J.getAssertionTypes().contains(typeName) : hasAssertJImport) {
            return Optional.of(variable);
        }
        return Optional.empty();
    }

    private static List<IToken> getAssertionCallParameters(List<IToken> tokens, TokenPatternMatch match) {
        int start = (Integer)match.groupIndices(1).getLast();
        int end = (Integer)match.groupIndices(2).getLast();
        return tokens.subList(start + 1, end);
    }

    private static boolean assertedObjectContainsMethodCall(List<IToken> assertedTokens) {
        return TokenStreamUtils.containsSequence(assertedTokens, (ETokenType[])new ETokenType[]{ETokenType.IDENTIFIER, ETokenType.LPAREN});
    }
}

