/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.xml;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import eu.cqse.check.framework.typetracker.ITypeResolution;
import eu.cqse.check.java.xml.XMLCheckUtils;
import eu.cqse.check.java.xml.XMLFeatures;
import eu.cqse.check.java.xml.XMLPatternMatcher;
import eu.cqse.check.java.xml.XMLType;
import eu.cqse.check.java.xml.XMLTypeInformation;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import org.conqat.lib.commons.collections.SetMap;

@Check(id="java:S6376", languages={ELanguage.JAVA}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE, ECheckParameter.TYPE_RESOLUTION})
public class XMLDenialOfServiceCheck
extends CheckImplementationBase {
    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        this.analyzeStatements(statements);
    }

    private void analyzeStatements(List<ShallowEntity> statements) throws CheckException {
        ITypeResolution lookup = this.context.getTypeResolution(this.getCodeViewOption());
        SetMap<ShallowEntity, XMLTypeInformation> xmlTypeInformation = XMLCheckUtils.extractXMLTypeInformation(statements, lookup);
        if (XMLDenialOfServiceCheck.docTypeIsEnabled(xmlTypeInformation)) {
            return;
        }
        Set<ShallowEntity> problematicEntities = XMLDenialOfServiceCheck.getProblematicEntities(xmlTypeInformation);
        for (ShallowEntity statement : problematicEntities) {
            this.buildFinding("Enable XML parsing limitations to prevent Denial of Service attacks", this.buildLocation().forEntity(statement)).createAndStore();
        }
    }

    private static Set<ShallowEntity> getProblematicEntities(SetMap<ShallowEntity, XMLTypeInformation> helpers) {
        Predicate<ShallowEntity> predicate = entity -> {
            Set typeInfos = (Set)helpers.getCollectionOrEmpty(entity);
            return typeInfos.stream().anyMatch(helper -> XMLDenialOfServiceCheck.secureProcessingIsDisabled(entity, helper.variable(), helper.xmlType()));
        };
        return new HashSet<ShallowEntity>(ShallowEntityTraversalUtils.selectEntities((Collection)helpers.getKeys(), predicate));
    }

    private static boolean secureProcessingIsDisabled(ShallowEntity statement, String variable, XMLType xmlParserType) {
        if (xmlParserType.hasFeatures(XMLFeatures.PARSING, XMLFeatures.SET_FEATURE)) {
            XMLPatternMatcher matcher = new XMLPatternMatcher(variable, (List<IToken>)statement.ownStartTokens());
            matcher.addFeaturePattern("XMLConstants", "FEATURE_SECURE_PROCESSING", false);
            matcher.addFeaturePattern("http://javax.xml.XMLConstants/feature/secure-processing", false);
            return matcher.hasMatch();
        }
        return false;
    }

    private static boolean docTypeIsEnabled(SetMap<ShallowEntity, XMLTypeInformation> helpers) {
        Predicate<ShallowEntity> predicate = entity -> {
            Set typeInfos = (Set)helpers.getCollectionOrEmpty(entity);
            return typeInfos.stream().anyMatch(helper -> XMLDenialOfServiceCheck.docTypeIsEnabled(entity, helper.variable(), helper.xmlType()));
        };
        return !ShallowEntityTraversalUtils.selectEntities((Collection)helpers.getKeys(), predicate).isEmpty();
    }

    private static boolean docTypeIsEnabled(ShallowEntity statement, String variable, XMLType xmlParserType) {
        if (xmlParserType.hasFeatures(XMLFeatures.PARSING, XMLFeatures.SET_FEATURE)) {
            XMLPatternMatcher matcher = new XMLPatternMatcher(variable, (List<IToken>)statement.ownStartTokens());
            matcher.addFeaturePattern("http://apache.org/xml/features/disallow-doctype-decl", true);
            return matcher.hasMatch();
        }
        return false;
    }
}

