/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.java.xml;

import eu.cqse.check.java.xml.XMLFeatures;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import org.checkerframework.checker.nullness.qual.Nullable;

enum XMLType {
    DOCUMENT_BUILDER_FACTORY("DocumentBuilderFactory", XMLFeatures.PARSING, XMLFeatures.SET_FEATURE, XMLFeatures.X_INCLUDE_AWARE, XMLFeatures.SET_VALIDATING, XMLFeatures.SET_ATTRIBUTE),
    SAX_PARSER_FACTORY("SAXParserFactory", XMLFeatures.PARSING, XMLFeatures.SET_FEATURE, XMLFeatures.X_INCLUDE_AWARE, XMLFeatures.SET_VALIDATING),
    TRANSFORMER_FACTORY("TransformerFactory", XMLFeatures.PARSING, XMLFeatures.SET_FEATURE, XMLFeatures.SET_PROPERTY, XMLFeatures.SET_ATTRIBUTE),
    SCHEMA_FACTORY("SchemaFactory", XMLFeatures.PARSING, XMLFeatures.SET_FEATURE, XMLFeatures.SET_PROPERTY),
    XML_READER("XMLReader", XMLFeatures.PARSING, XMLFeatures.SET_FEATURE),
    SAX_BUILDER("SAXBuilder", XMLFeatures.PARSING, XMLFeatures.SET_FEATURE, XMLFeatures.SET_VALIDATING, XMLFeatures.CUSTOM_ENTITY_RESOLVER),
    SAX_READER("SAXReader", XMLFeatures.PARSING, XMLFeatures.SET_FEATURE, XMLFeatures.CUSTOM_ENTITY_RESOLVER),
    SAX_PARSER("SAXParser", XMLFeatures.PARSING, XMLFeatures.SET_PROPERTY),
    XML_INPUT_FACTORY("XMLInputFactory", XMLFeatures.PARSING, XMLFeatures.SET_FEATURE, XMLFeatures.CUSTOM_ENTITY_RESOLVER, XMLFeatures.SET_PROPERTY),
    VALIDATOR("Validator", XMLFeatures.PARSING, XMLFeatures.SET_PROPERTY),
    DOCUMENT_BUILDER("DocumentBuilder", XMLFeatures.PARSING, XMLFeatures.CUSTOM_ENTITY_RESOLVER),
    DOM_VALIDATE_CONTEXT("DOMValidateContext", XMLFeatures.SIGNATURE_VALIDATION, XMLFeatures.SET_FEATURE);

    private final String typename;
    private final EnumSet<XMLFeatures> supportedFeatures = EnumSet.noneOf(XMLFeatures.class);

    private XMLType(String typename, XMLFeatures ... features) {
        this.typename = typename;
        this.supportedFeatures.addAll(List.of(features));
    }

    public String getTypename() {
        return this.typename;
    }

    public static @Nullable XMLType getXMLType(String typename) {
        for (XMLType type : XMLType.values()) {
            if (!type.getTypename().equals(typename)) continue;
            return type;
        }
        return null;
    }

    public boolean hasFeature(XMLFeatures feature) {
        return this.supportedFeatures.contains((Object)feature);
    }

    public boolean hasFeatures(XMLFeatures ... features) {
        return this.supportedFeatures.containsAll(Set.of(features));
    }
}

