/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.objc;

import eu.cqse.check.clike.CLikeMethodParameterCountCheckBase;
import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.shallowparser.TokenStreamTextUtils;
import eu.cqse.check.framework.shallowparser.TokenStreamUtils;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.util.tokens.TokenPattern;
import eu.cqse.check.framework.util.tokens.TokenPatternMatch;
import java.util.List;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-objc-method-parameter-count", languages={ELanguage.OBJECTIVE_C, ELanguage.OBJECTIVE_CPP}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class ObjcMethodParameterCountCheck
extends CLikeMethodParameterCountCheckBase {
    private static final String CHECK_NAME = "Methods should not have too many parameters (Objective-C)";
    private static final TokenPattern CPP_DELEGATING_OR_INHERITING_CONSTRUCTOR_PATTERN = new TokenPattern().sequence(new Object[]{ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).skipTo(new Object[]{ETokenType.COLON}).skipUntil(new Object[]{ETokenType.IDENTIFIER, ETokenType.LPAREN}).sequence(new Object[]{ETokenType.IDENTIFIER}).skipNested((Object)ETokenType.LPAREN, (Object)ETokenType.RPAREN, false).skipTo(new Object[]{ETokenType.LBRACE});
    @CheckOption(name="Methods should not have too many parameters (Objective-C): max. parameters", description="Maximum parameter count")
    private int maxNumberOfAllowedParameters = 7;

    @Override
    protected ELanguage determineMethodLanguage(ShallowEntity methodEntity) {
        ELanguage contextLanguage = this.context.getLanguage();
        UnmodifiableList methodStartTokens = methodEntity.ownStartTokens();
        boolean methodStartTokensContainColon = methodStartTokens.stream().anyMatch(token -> token.getType() == ETokenType.COLON);
        if (!methodStartTokensContainColon) {
            return switch (contextLanguage) {
                case ELanguage.OBJECTIVE_C -> ELanguage.C;
                case ELanguage.OBJECTIVE_CPP -> ELanguage.CPP;
                default -> contextLanguage;
            };
        }
        if (this.isCppConstructor(methodEntity)) {
            return ELanguage.CPP;
        }
        return contextLanguage;
    }

    private boolean isCppConstructor(ShallowEntity methodEntity) {
        if (this.context.getLanguage() != ELanguage.OBJECTIVE_CPP) {
            return false;
        }
        boolean isConstructor = methodEntity.getSubtype().equals("constructor");
        if (!isConstructor) {
            return false;
        }
        UnmodifiableList methodStartTokens = methodEntity.ownStartTokens();
        int indexOfConstructorName = TokenStreamTextUtils.findFirst((List)methodStartTokens, (String)methodEntity.getName());
        if (indexOfConstructorName == -1) {
            return false;
        }
        List tokensBeginningAtConstructorName = CollectionUtils.subListFrom((List)methodStartTokens, (int)indexOfConstructorName);
        TokenPatternMatch patternMatch = CPP_DELEGATING_OR_INHERITING_CONSTRUCTOR_PATTERN.matchAtStartOf(tokensBeginningAtConstructorName);
        return patternMatch != null;
    }

    @Override
    protected int getMaximumAllowedParameterCount() {
        return this.maxNumberOfAllowedParameters;
    }

    @Override
    protected boolean isDerivedMethod(ShallowEntity methodEntity) {
        return TokenStreamUtils.containsAny((List)methodEntity.includedTokens(), (ETokenType[])new ETokenType[]{ETokenType.SUPER});
    }
}

