/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.types.SimulinkDataTypeUtils;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse-simulink-use-of-fixed-point-type", languages={ELanguage.SIMULINK})
public class SimulinkUseOfFixedPointDataTypeCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)("Make sure to avoid " + MarkupUtils.formatAsSourceCode((String)"fixdt") + " data type. If applicable, change the output data type of the blocks to " + MarkupUtils.formatAsSourceCode((String)"Inherit: auto") + " or " + MarkupUtils.formatAsSourceCode((String)"Inherit via back propagation") + "."));

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)model, (boolean)false, (boolean)false)) {
            String outputDataType = SimulinkDataTypeUtils.getUnresolvedOutputDataType((SimulinkBlock)block);
            if (StringUtils.isEmpty((String)outputDataType) || !outputDataType.toLowerCase().startsWith("fixdt")) continue;
            this.buildFinding(block.getName() + " contains a fixed width output data type", (ElementLocation)this.buildLocation().forSimulinkBlock(block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

