/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.naming_conventions;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.simulink.naming_conventions.SimulinkNameLengthCheckUtils;
import java.util.Optional;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.util.SimulinkUtils;

@Check(id="cqse.jmaab.jc_0244", languages={ELanguage.SIMULINK})
public class SimulinkBlockInOutPortNamesLengthCheck
extends CheckImplementationBase {
    @CheckOption(name="Minimum length of port names", description="The minimum number of characters for names of ports.")
    private int minimumLength = 0;
    @CheckOption(name="Maximum length of port names", description="The maximum number of characters for names of ports.")
    private int maximumLength = 63;

    public void execute() {
        Optional optionalSimulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile();
        if (optionalSimulinkModel.isEmpty()) {
            return;
        }
        for (SimulinkBlock block : SimulinkUtils.listBlocksDepthFirst((SimulinkBlock)((SimulinkBlock)optionalSimulinkModel.get()), (boolean)false, (boolean)false)) {
            if (!SimulinkUtils.isInport((SimulinkBlock)block) && !SimulinkUtils.isOutport((SimulinkBlock)block)) continue;
            SimulinkNameLengthCheckUtils.performLengthRestrictionCheck(this.context, this.minimumLength, this.maximumLength, block.getName(), "Port", this.buildLocation().forSimulinkBlock(block));
        }
    }
}

