/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.simulink.phases;

import eu.cqse.check.framework.core.ICheckContext;
import eu.cqse.check.simulink.simulink.phases.ReferencedItem;
import eu.cqse.check.simulink.simulink.phases.SimulinkDataDictionaryLoadingPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReference;
import eu.cqse.check.simulink.simulink.phases.SimulinkFileReferencesPhase;
import eu.cqse.check.simulink.simulink.phases.SimulinkModelBlockIdListingPhase;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.conqat.engine.resource.util.UniformPathUtils;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.SetMap;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.builder.SimulinkDataDictionary;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.util.SimulinkUtils;

public class SimulinkCheckFileReferencesResolver {
    private final Function<String, List<SimulinkFileReference>> fileReferencesResultAccessor;
    private final Function<String, List<SimulinkFileReference>> fileReferencesInvertedResultAccessor;
    private final Function<String, List<SimulinkModelBlockIdListingPhase.BlockIdDefinition>> blockIdListingPhaseResultAccessor;
    private final Function<String, List<SimulinkModelBlockIdListingPhase.BlockIdDefinition>> blockIdListingPhaseInvertedResultAccessor;
    private final SetMap<SimulinkModel, SimulinkDataDictionary> dictionariesReferences = new SetMap();

    public SimulinkCheckFileReferencesResolver(ICheckContext context) {
        this.fileReferencesResultAccessor = context.accessPhaseResult(SimulinkFileReferencesPhase.class);
        this.fileReferencesInvertedResultAccessor = context.accessPhaseInvertedResult(SimulinkFileReferencesPhase.class);
        this.blockIdListingPhaseResultAccessor = context.accessPhaseResult(SimulinkModelBlockIdListingPhase.class);
        this.blockIdListingPhaseInvertedResultAccessor = context.accessPhaseInvertedResult(SimulinkModelBlockIdListingPhase.class);
    }

    public SimulinkCheckFileReferencesResolver(Function<String, List<SimulinkFileReference>> fileReferencesResultAccessor, Function<String, List<SimulinkFileReference>> fileReferencesInvertedResultAccessor, Function<String, List<SimulinkModelBlockIdListingPhase.BlockIdDefinition>> blockIdListingPhaseResultAccessor, Function<String, List<SimulinkModelBlockIdListingPhase.BlockIdDefinition>> blockIdListingPhaseInvertedResultAccessor) {
        this.fileReferencesResultAccessor = fileReferencesResultAccessor;
        this.fileReferencesInvertedResultAccessor = fileReferencesInvertedResultAccessor;
        this.blockIdListingPhaseResultAccessor = blockIdListingPhaseResultAccessor;
        this.blockIdListingPhaseInvertedResultAccessor = blockIdListingPhaseInvertedResultAccessor;
    }

    public List<SimulinkDataDictionary> getSimulinkDataDictionariesForModel(SimulinkModel model, Function<String, List<SimulinkDataDictionaryLoadingPhase.DataDictionaryContainer>> dataDictionaryLoadingPhaseResultAccessor) {
        if (this.dictionariesReferences.containsCollection((Object)model)) {
            return Objects.requireNonNull((Set)this.dictionariesReferences.getCollection((Object)model)).stream().toList();
        }
        List<String> relevantDictionaryUniformPaths = this.determineRelevantDictionaryUniformPathsForModel(model);
        ArrayList<SimulinkDataDictionary> resultDictionaries = new ArrayList<SimulinkDataDictionary>();
        for (String referencedDictionaryFileName : relevantDictionaryUniformPaths) {
            resultDictionaries.addAll(CollectionUtils.map((Collection)dataDictionaryLoadingPhaseResultAccessor.apply(referencedDictionaryFileName), SimulinkDataDictionaryLoadingPhase.DataDictionaryContainer::getAdditionalInformation));
        }
        resultDictionaries.addAll(this.getDictionariesFromModelsReferencingModel(model));
        this.dictionariesReferences.addAll((Object)model, new HashSet(resultDictionaries));
        return resultDictionaries;
    }

    private Set<SimulinkDataDictionary> getDictionariesFromModelsReferencingModel(SimulinkModel model) {
        if (model == null) {
            return Collections.emptySet();
        }
        HashSet<SimulinkDataDictionary> dictionaries = new HashSet<SimulinkDataDictionary>();
        Set<String> relevantModelUniformPaths = this.determineModelsReferencingModel(model.getUniformPath());
        for (String relevantModelUniformPath : relevantModelUniformPaths) {
            for (Map.Entry dictRef : this.dictionariesReferences.entrySet()) {
                if (!((SimulinkModel)dictRef.getKey()).getUniformPath().equals(relevantModelUniformPath)) continue;
                dictionaries.addAll((Collection)dictRef.getValue());
            }
        }
        return dictionaries;
    }

    private @NonNull List<String> determineRelevantDictionaryUniformPathsForModel(SimulinkModel model) {
        if (model == null) {
            return Collections.emptyList();
        }
        Set<String> relevantModelUniformPaths = this.determineModelsReferencingModel(model.getUniformPath());
        HashSet<String> referencedDictionaryFileNames = new HashSet<String>();
        for (String relevantModelUniformPath : relevantModelUniformPaths) {
            referencedDictionaryFileNames.addAll(this.getDictionaryFileNamesDirectlyReferencedByModel(relevantModelUniformPath));
        }
        HashSet<String> relevantDictionaryUniformPaths = new HashSet<String>();
        for (String referencedDictionaryFileName : referencedDictionaryFileNames) {
            relevantDictionaryUniformPaths.addAll(this.getDictionaryClosure(referencedDictionaryFileName));
        }
        return CollectionUtils.sort(relevantDictionaryUniformPaths);
    }

    private Set<String> determineModelsReferencingModel(String uniformPath) {
        HashSet<String> uniformPaths = new HashSet<String>(Collections.singletonList(uniformPath));
        ArrayDeque<String> worklist = new ArrayDeque<String>(Collections.singletonList(uniformPath));
        HashSet<String> seenPaths = new HashSet<String>();
        while (!worklist.isEmpty()) {
            String currentModelUniformPath = (String)worklist.pop();
            if (!seenPaths.add(currentModelUniformPath)) continue;
            String currentSimpleFileName = UniformPathUtils.getElementName((String)currentModelUniformPath);
            String modelName = StringUtils.removeLastPart((String)currentSimpleFileName, (char)'.');
            ReferencedItem referenceItem = new ReferencedItem(ReferencedItem.EReferencedItemType.MODEL_FILE, modelName);
            String storageString = referenceItem.toStorageString();
            for (SimulinkFileReference ref : this.fileReferencesInvertedResultAccessor.apply(storageString)) {
                uniformPaths.add(ref.getUniformPath());
            }
            List<SimulinkModelBlockIdListingPhase.BlockIdDefinition> blockIdDefinitionsInCurrentFile = this.blockIdListingPhaseResultAccessor.apply(currentModelUniformPath);
            List blockIdsInCurrentFile = CollectionUtils.map(blockIdDefinitionsInCurrentFile, SimulinkModelBlockIdListingPhase.BlockIdDefinition::getValue);
            for (String blockIdInCurrentFile : blockIdsInCurrentFile) {
                ReferencedItem blockIdReferenceItem = new ReferencedItem(ReferencedItem.EReferencedItemType.BLOCK_IN_LIBRARY, blockIdInCurrentFile);
                for (SimulinkFileReference ref : this.fileReferencesInvertedResultAccessor.apply(blockIdReferenceItem.toStorageString())) {
                    uniformPaths.add(ref.getUniformPath());
                }
            }
        }
        return uniformPaths;
    }

    private @NonNull List<String> getDictionaryFileNamesDirectlyReferencedByModel(String modelUniformPath) {
        return this.fileReferencesResultAccessor.apply(modelUniformPath).stream().map(SimulinkFileReference::getReferenceItem).filter(refValue -> ReferencedItem.EReferencedItemType.DATA_DICTIONARY == refValue.getType()).map(ReferencedItem::getTarget).collect(Collectors.toList());
    }

    private List<String> getDictionaryClosure(String dataDictionaryFileName) {
        ArrayList<String> referencedDictionaries = new ArrayList<String>(this.getDictionaryUniformPathsBySimpleFileNames(dataDictionaryFileName));
        ArrayDeque<String> worklist = new ArrayDeque<String>(referencedDictionaries);
        HashSet<String> seenPaths = new HashSet<String>();
        while (!worklist.isEmpty()) {
            String currentUniformPath = (String)worklist.pop();
            if (!seenPaths.add(currentUniformPath)) continue;
            List<String> subDictionarySimpleFileNames = this.fileReferencesResultAccessor.apply(currentUniformPath).stream().filter(reference -> ReferencedItem.EReferencedItemType.DATA_DICTIONARY == reference.getReferenceItem().getType()).map(reference -> reference.getReferenceItem().getTarget()).toList();
            for (String dictionaryFileName : subDictionarySimpleFileNames) {
                List<String> subDictionaryUniformPaths = this.getDictionaryUniformPathsBySimpleFileNames(dictionaryFileName);
                referencedDictionaries.addAll(subDictionaryUniformPaths);
                worklist.addAll(subDictionaryUniformPaths);
            }
        }
        return referencedDictionaries;
    }

    private List<String> getDictionaryUniformPathsBySimpleFileNames(String dataDictionaryFileName) {
        ReferencedItem referencedItem = new ReferencedItem(ReferencedItem.EReferencedItemType.DICTIONARY_SIMPLE_FILE_NAME, dataDictionaryFileName);
        List<SimulinkFileReference> references = this.fileReferencesInvertedResultAccessor.apply(referencedItem.toStorageString());
        return CollectionUtils.map(references, SimulinkFileReference::getUniformPath);
    }

    public List<String> getModelsAccessingDataDictionary(String dictionaryUniformPath) {
        Set<String> modelsReferringToDictionary = this.discoverModelsThatTransitivelyReferToDictionary(dictionaryUniformPath);
        HashSet<String> allRelevantModels = new HashSet<String>(modelsReferringToDictionary);
        for (String model : modelsReferringToDictionary) {
            allRelevantModels.addAll(this.discoverModelsTransitivelyReferencedBy(model));
        }
        return CollectionUtils.sort(allRelevantModels);
    }

    private Set<String> discoverModelsTransitivelyReferencedBy(String initialModel) {
        HashSet<String> seenModelPaths = new HashSet<String>();
        ArrayDeque<String> worklist = new ArrayDeque<String>(Collections.singletonList(initialModel));
        while (!worklist.isEmpty()) {
            String current = (String)worklist.pop();
            if (!seenModelPaths.add(current)) continue;
            List<SimulinkFileReference> referencesFromCurrent = this.fileReferencesResultAccessor.apply(current);
            for (SimulinkFileReference referenceFromCurrent : referencesFromCurrent) {
                if (referenceFromCurrent.getReferenceItem().getType() == ReferencedItem.EReferencedItemType.BLOCK_IN_LIBRARY) {
                    List<SimulinkModelBlockIdListingPhase.BlockIdDefinition> modelsContainingReferencedBlock = this.blockIdListingPhaseInvertedResultAccessor.apply(referenceFromCurrent.getReferenceItem().getTarget());
                    worklist.addAll(CollectionUtils.map(modelsContainingReferencedBlock, SimulinkModelBlockIdListingPhase.BlockIdDefinition::getUniformPath));
                    continue;
                }
                if (referenceFromCurrent.getReferenceItem().getType() != ReferencedItem.EReferencedItemType.MODEL_FILE) continue;
                String simpleFileName = UniformPathUtils.getElementName((String)referenceFromCurrent.getReferenceItem().getTarget());
                List<SimulinkFileReference> potentialTargetFiles = this.fileReferencesInvertedResultAccessor.apply(new ReferencedItem(ReferencedItem.EReferencedItemType.MODEL_SIMPLE_FILE_NAME, simpleFileName).toStorageString());
                worklist.addAll(CollectionUtils.map(potentialTargetFiles, SimulinkFileReference::getUniformPath));
            }
        }
        return seenModelPaths;
    }

    private Set<String> discoverModelsThatTransitivelyReferToDictionary(String initialDictionaryUniformPath) {
        HashSet<String> seenDictionaryUniformPaths = new HashSet<String>();
        HashSet<String> modelUniformPaths = new HashSet<String>();
        ArrayDeque<String> worklist = new ArrayDeque<String>(Collections.singletonList(initialDictionaryUniformPath));
        while (!worklist.isEmpty()) {
            String currentUniformPath = (String)worklist.pop();
            if (SimulinkUtils.isSimulinkDataDictionary((String)currentUniformPath)) {
                if (!seenDictionaryUniformPaths.add(currentUniformPath)) {
                    continue;
                }
            } else {
                modelUniformPaths.add(currentUniformPath);
                continue;
            }
            String dictionarySimpleFileName = UniformPathUtils.getElementName((String)currentUniformPath);
            ReferencedItem referencedItem = new ReferencedItem(ReferencedItem.EReferencedItemType.DATA_DICTIONARY, dictionarySimpleFileName);
            List<SimulinkFileReference> referencesToCurrentDictionary = this.fileReferencesInvertedResultAccessor.apply(referencedItem.toStorageString());
            for (SimulinkFileReference reference : referencesToCurrentDictionary) {
                String referringPath = reference.getUniformPath();
                worklist.push(referringPath);
            }
        }
        return modelUniformPaths;
    }
}

