/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import java.text.MessageFormat;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.ParameterizedElement;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.IStateflowNodeContainer;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.model.stateflow.StateflowNodeBase;
import org.conqat.lib.simulink.model.stateflow.StateflowState;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.na_0040", languages={ELanguage.SIMULINK})
public class SimulinkAmountOfStatesPerContainerCheck
extends CheckImplementationBase {
    @CheckOption(name="Maximum number of visible states per container", description="The maximum number of visible states that are allowed within a container.")
    private int maximumNumberOfVisibleStates = 10;
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Encapsulate states inside sub-charts so that the threshold is not exceeded");

    public void execute() {
        SimulinkModel simulinkModel = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (simulinkModel == null) {
            return;
        }
        StateflowMachine machine = simulinkModel.getStateflowMachine();
        if (machine == null) {
            return;
        }
        for (StateflowChart chart : machine.getCharts(false)) {
            this.checkContainer((IStateflowNodeContainer<?>)chart);
            for (StateflowState state : StateflowUtils.listStatesDepthFirst((StateflowChart)chart, (boolean)false)) {
                if (!SimulinkAmountOfStatesPerContainerCheck.shouldIncludeState(state)) continue;
                this.checkContainer((IStateflowNodeContainer<?>)state);
            }
        }
    }

    private void checkContainer(IStateflowNodeContainer<?> container) {
        int numberOfStates = SimulinkAmountOfStatesPerContainerCheck.calculateNumberOfVisibleStates(SimulinkAmountOfStatesPerContainerCheck.getStatesOfContainer(container));
        if (numberOfStates > this.maximumNumberOfVisibleStates) {
            this.createFindingForContainer(container);
        }
    }

    private void createFindingForContainer(IStateflowNodeContainer<?> container) {
        String messageTemplate = "Container: {0} has more than {1} states";
        if (container instanceof StateflowChart) {
            StateflowBlock block = ((StateflowChart)container).getStateflowBlock();
            String containerName = MarkupUtils.formatAsSourceCode((String)block.getNamePretty());
            String findingMessage = MessageFormat.format(messageTemplate, containerName, this.maximumNumberOfVisibleStates);
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forSimulinkBlock((SimulinkBlock)block)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        } else {
            StateflowState state = (StateflowState)container;
            String containerId = MarkupUtils.formatAsSourceCode((String)StringUtils.getLastPart((String)Objects.requireNonNull(StateflowUtils.getStateName((StateflowState)state)), (String)"/"));
            String findingMessage = MessageFormat.format(messageTemplate, containerId, this.maximumNumberOfVisibleStates);
            this.buildFinding(findingMessage, (ElementLocation)this.buildLocation().forStateflowNode((StateflowNodeBase)state)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static int calculateNumberOfVisibleStates(Set<StateflowState> states) {
        int totalCountedStates = 0;
        for (StateflowState state : states) {
            Set<StateflowState> substates = SimulinkAmountOfStatesPerContainerCheck.getStatesOfContainer(state);
            if (state.isGroupState()) {
                totalCountedStates += SimulinkAmountOfStatesPerContainerCheck.calculateNumberOfVisibleStates(substates);
                continue;
            }
            if (state.isSubState() && !state.isSubChart()) {
                totalCountedStates += 1 + SimulinkAmountOfStatesPerContainerCheck.calculateNumberOfVisibleStates(substates);
                continue;
            }
            if (state.isSimulinkFunction() || state.isFunctionState() || state.isMatlabFunction()) continue;
            ++totalCountedStates;
        }
        return totalCountedStates;
    }

    private static Set<StateflowState> getStatesOfContainer(IStateflowNodeContainer<?> container) {
        boolean isSubChart;
        UnmodifiableSet nodes = container.getNodes();
        boolean bl = isSubChart = container instanceof StateflowState && ((StateflowState)container).isSubChart();
        if (isSubChart) {
            nodes = ((StateflowState)container).getSubViewer().getNodes();
        }
        return nodes.stream().filter(node -> !StateflowUtils.isCommented((ParameterizedElement)node) && node instanceof StateflowState).map(StateflowState.class::cast).collect(Collectors.toSet());
    }

    private static boolean shouldIncludeState(StateflowState state) {
        return state.isSubState() || state.isGroupState() || state.isSubChart();
    }
}

