/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;

@Check(id="cqse.hism.hisf_0001", languages={ELanguage.SIMULINK})
public class SimulinkStateMachineTypeCheck
extends CheckImplementationBase {
    private static final String CLASSIC_MACHINE_TYPE = "Classic";
    private static final String MACHINE_SUFFIX = "_MACHINE";
    @CheckOption(name="Expected State Machine type", description="The state machine type that all Stateflow charts shall use. Valid values are Classic, Mealy and Moore.")
    private String expectedStateMachineType = "Classic";
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Set the state machine type to the configured one for this chart.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null || model.getStateflowMachine() == null) {
            return;
        }
        for (StateflowChart chart : model.getStateflowMachine().getCharts(false)) {
            String stateMachineType;
            if (SimulinkStateMachineTypeCheck.canSkip(chart) || (stateMachineType = SimulinkStateMachineTypeCheck.getStateMachineType(chart)).equalsIgnoreCase(this.expectedStateMachineType)) continue;
            this.buildFinding("State machine type is not set to " + this.expectedStateMachineType, (ElementLocation)this.buildLocation().forSimulinkBlock((SimulinkBlock)chart.getStateflowBlock())).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }

    private static boolean canSkip(StateflowChart chart) {
        if (chart == null) {
            return true;
        }
        StateflowBlock stateflowBlock = chart.getStateflowBlock();
        SimulinkBlock parent = stateflowBlock.getParent();
        return parent != null && parent.isStateflowChartBlock();
    }

    private static String getStateMachineType(StateflowChart chart) {
        String stateMachineType = chart.getParameter("stateMachineType");
        if (stateMachineType == null) {
            return CLASSIC_MACHINE_TYPE;
        }
        return StringUtils.stripSuffix((String)stateMachineType, (String)MACHINE_SUFFIX);
    }
}

