/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.simulink.stateflow;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.FindingPropertyList;
import eu.cqse.check.framework.scanner.ELanguage;
import org.conqat.engine.commons.findings.location.ElementLocation;
import org.conqat.lib.commons.collections.UnmodifiableCollection;
import org.conqat.lib.commons.markup.MarkupUtils;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.simulink.model.SimulinkBlock;
import org.conqat.lib.simulink.model.SimulinkInPort;
import org.conqat.lib.simulink.model.SimulinkLine;
import org.conqat.lib.simulink.model.SimulinkModel;
import org.conqat.lib.simulink.model.SimulinkOutPort;
import org.conqat.lib.simulink.model.SimulinkPropagatedSignalLabels;
import org.conqat.lib.simulink.model.stateflow.StateflowBlock;
import org.conqat.lib.simulink.model.stateflow.StateflowChart;
import org.conqat.lib.simulink.model.stateflow.StateflowMachine;
import org.conqat.lib.simulink.util.SimulinkUtils;
import org.conqat.lib.simulink.util.StateflowUtils;

@Check(id="cqse.maab.db_0123", languages={ELanguage.SIMULINK})
public class SimulinkStateflowPortNamesCheck
extends CheckImplementationBase {
    private static final FindingPropertyList RECOMMENDED_ACTION = FindingPropertyList.singleton((String)"Recommended Action", (String)"Ensure that the Stateflow ports are connected to the correct signals. If this is the case, change the names of either the signals or the Stateflow ports so that they match.");

    public void execute() {
        SimulinkModel model = this.context.getSimulinkContext().getSimulinkModelForModelFile().orElse(null);
        if (model == null) {
            return;
        }
        StateflowMachine machine = model.getStateflowMachine();
        if (machine == null) {
            return;
        }
        SimulinkPropagatedSignalLabels propagatedSignalLabels = this.context.getSimulinkContext().getPropagatedSimulinkSignalLabelsForFile().orElse(null);
        for (StateflowChart chart : machine.getCharts(false)) {
            StateflowBlock stateflowBlock = chart.getStateflowBlock();
            if (StateflowUtils.isMatlabFunctionBlock((SimulinkBlock)stateflowBlock)) continue;
            this.compareSignalAndInPorts((UnmodifiableCollection<SimulinkInPort>)stateflowBlock.getInPorts(), propagatedSignalLabels);
            this.compareSignalAndOutPorts((UnmodifiableCollection<SimulinkOutPort>)stateflowBlock.getOutPorts(), propagatedSignalLabels);
        }
    }

    private void compareSignalAndInPorts(UnmodifiableCollection<SimulinkInPort> inPorts, SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        for (SimulinkInPort inport : inPorts) {
            SimulinkBlock port = StateflowUtils.getStateflowInport((SimulinkInPort)inport);
            if (port == null) continue;
            String portName = port.getName();
            this.compareSignalAndPortName(SimulinkStateflowPortNamesCheck.getInportSignalName(inport, propagatedSignalLabels), portName, inport.getLine());
        }
    }

    private void compareSignalAndOutPorts(UnmodifiableCollection<SimulinkOutPort> outPorts, SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        for (SimulinkOutPort outport : outPorts) {
            String portName = SimulinkUtils.getPropagatedSignalName((SimulinkOutPort)outport, (SimulinkPropagatedSignalLabels)propagatedSignalLabels);
            if (portName == null) {
                SimulinkBlock port = StateflowUtils.getStateflowOutport((SimulinkOutPort)outport);
                if (port == null) continue;
                portName = port.getName();
            }
            String propagatedSignalVisibility = outport.getParameter("ShowPropagatedSignals");
            String signalName = SimulinkStateflowPortNamesCheck.getSignalName(outport.getSignalName().orElse(null), portName, propagatedSignalVisibility);
            this.compareSignalAndPortName(signalName, portName, outport.getAnyLine());
        }
    }

    private static String getInportSignalName(SimulinkInPort inport, SimulinkPropagatedSignalLabels propagatedSignalLabels) {
        SimulinkOutPort simulinkOutPort;
        String propagatedSignalName = null;
        String propagatedSignalVisibility = null;
        SimulinkLine simulinkLine = inport.getLine();
        if (simulinkLine != null && (simulinkOutPort = simulinkLine.getSrcPort()) != null) {
            propagatedSignalName = SimulinkUtils.getPropagatedSignalName((SimulinkOutPort)simulinkOutPort, (SimulinkPropagatedSignalLabels)propagatedSignalLabels);
            propagatedSignalVisibility = simulinkOutPort.getParameter("ShowPropagatedSignals");
        }
        return SimulinkStateflowPortNamesCheck.getSignalName(inport.getSignalName().orElse(null), propagatedSignalName, propagatedSignalVisibility);
    }

    private static String getSignalName(String signalName, String propagatedSignalName, String propagatedSignalVisibility) {
        if (!StringUtils.isEmpty((String)propagatedSignalName) && "on".equals(propagatedSignalVisibility)) {
            return propagatedSignalName;
        }
        return signalName;
    }

    private void compareSignalAndPortName(String signalName, String portName, SimulinkLine line) {
        if (line == null || signalName == null) {
            return;
        }
        if (signalName.startsWith("<") && signalName.endsWith(">")) {
            signalName = signalName.substring(1, signalName.length() - 1);
        }
        if (!signalName.isEmpty() && !signalName.equals(portName)) {
            this.buildFinding("Name of the signal " + MarkupUtils.formatAsSourceCode((String)signalName) + " differs from name of the connected Stateflow port " + MarkupUtils.formatAsSourceCode((String)portName), (ElementLocation)this.buildLocation().forSimulinkLine(line)).addFindingProperties(RECOMMENDED_ACTION).createAndStore();
        }
    }
}

