/*
 * Decompiled with CFR 0.152.
 */
package eu.cqse.check.sql_like;

import eu.cqse.check.framework.core.Check;
import eu.cqse.check.framework.core.CheckException;
import eu.cqse.check.framework.core.CheckImplementationBase;
import eu.cqse.check.framework.core.ECheckParameter;
import eu.cqse.check.framework.core.option.CheckOption;
import eu.cqse.check.framework.scanner.ELanguage;
import eu.cqse.check.framework.scanner.ETokenType;
import eu.cqse.check.framework.scanner.IToken;
import eu.cqse.check.framework.shallowparser.framework.EShallowEntityType;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntity;
import eu.cqse.check.framework.shallowparser.framework.ShallowEntityTraversalUtils;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.conqat.lib.commons.collections.UnmodifiableList;

@Check(id="cqse-avoid-delete-update-without-where", languages={ELanguage.PLSQL, ELanguage.TSQL, ELanguage.ESQL}, parameters={ECheckParameter.ABSTRACT_SYNTAX_TREE})
public class AvoidDeleteOrUpdateWithoutWhereCheck
extends CheckImplementationBase {
    private static final Set<String> KEYWORD_NAMES = new HashSet<String>(List.of("delete", "update"));
    private static final String CHECK_NAME = "Delete/Update statement without Where";
    @CheckOption(name="Delete/Update statement without Where - ignore local temporary tables", description="If enabled, no finding is created when a local temporary table is modified without a 'WHERE' clause in T-SQL. This option is specifically for T-SQL where local temporary tables are denoted by a '#' prefix.")
    private boolean ignoreLocalTemporaryTables = false;

    public void execute() throws CheckException {
        List statements = ShallowEntityTraversalUtils.listEntitiesOfType((Collection)this.context.getAbstractSyntaxTree(this.getCodeViewOption()), (EShallowEntityType)EShallowEntityType.STATEMENT);
        for (ShallowEntity statement : statements) {
            if ((AvoidDeleteOrUpdateWithoutWhereCheck.isInsideMergeStatement(statement) || !KEYWORD_NAMES.contains(statement.getSubtype())) && !KEYWORD_NAMES.contains(statement.getName())) continue;
            this.processEntity(statement);
        }
    }

    private static boolean isInsideMergeStatement(ShallowEntity statement) {
        return statement.getParent() != null && statement.getParent().getType() == EShallowEntityType.STATEMENT && statement.getParent().getSubtype().equals("merge");
    }

    private void processEntity(ShallowEntity entity) {
        UnmodifiableList tokens = entity.ownStartTokens();
        if (!KEYWORD_NAMES.contains(((IToken)tokens.getFirst()).getText().toLowerCase())) {
            return;
        }
        if (this.ignoreLocalTemporaryTables && AvoidDeleteOrUpdateWithoutWhereCheck.involvesLocalTempTable((List<IToken>)tokens)) {
            return;
        }
        if (tokens.stream().noneMatch(iToken -> iToken.getType() == ETokenType.WHERE || iToken.getType() == ETokenType.JOIN)) {
            this.buildFinding("Usage of `" + ((IToken)tokens.getFirst()).getText() + "` without a `WHERE` clause should be avoided", this.buildLocation().forToken((IToken)tokens.getFirst())).createAndStore();
        }
    }

    private static boolean involvesLocalTempTable(List<IToken> tokens) {
        return tokens.stream().anyMatch(token -> token.getText().startsWith("#") && !token.getText().startsWith("##") && token.getType() == ETokenType.IDENTIFIER);
    }
}

