/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.wia;

import com.teamscale.wia.EWorkItemType;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.Arrays;
import java.util.EnumSet;
import java.util.Set;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.engine.index.shared.CommitDescriptor;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.UnmodifiableSet;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.uniformpath.UniformPath;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;
import org.jetbrains.annotations.VisibleForTesting;

public final class WiaUtils {
    @VisibleForTesting
    public static final String BRANCH_NAME_PREFIX = "issue-reader-";
    private static final UnmodifiableSet<UniformPath.EType> WORK_ITEM_UNIFORM_PATH_TYPES = CollectionUtils.asUnmodifiable(EnumSet.copyOf(Arrays.stream(EWorkItemType.values()).map(EWorkItemType::getUniformPathType).collect(Collectors.toSet())));
    private static final UnmodifiableSet<ELanguage> WIA_ENABLED_LANGUAGES = CollectionUtils.asUnmodifiable(EnumSet.copyOf(Arrays.stream(EWorkItemType.values()).map(EWorkItemType::getLanguage).collect(Collectors.toSet())));
    private static final Pattern CONNECTOR_ID_CLEANUP = Pattern.compile("[^a-zA-Z0-9]");

    public static boolean isWiaEnabledLanguage(@Nullable ELanguage language) {
        return WIA_ENABLED_LANGUAGES.contains((Object)language);
    }

    public static boolean containsWiaEnabledLanguage(Set<ELanguage> languages) {
        return languages.stream().anyMatch(arg_0 -> WIA_ENABLED_LANGUAGES.contains(arg_0));
    }

    public static Set<ELanguage> getWiaEnabledLanguages() {
        return WIA_ENABLED_LANGUAGES;
    }

    public static boolean isWorkItemPath(UniformPath uniformPath) {
        return WORK_ITEM_UNIFORM_PATH_TYPES.contains((Object)uniformPath.getType());
    }

    public static boolean isWorkItemPath(String uniformPath) {
        return WORK_ITEM_UNIFORM_PATH_TYPES.stream().map(UniformPath.EType::getPrefix).anyMatch(uniformPath::startsWith);
    }

    public static String getWorkItemConnectorBranchName(String connectorId) {
        return BRANCH_NAME_PREFIX + StringUtils.replaceAll((String)connectorId, (Pattern)CONNECTOR_ID_CLEANUP, (String)"");
    }

    public static boolean isWorkItemConnectorBranch(String branch) {
        return branch != null && branch.startsWith(BRANCH_NAME_PREFIX);
    }

    public static boolean isWorkItemConnectorCommit(CommitDescriptor commitDescriptor) {
        return commitDescriptor != null && WiaUtils.isWorkItemConnectorBranch(commitDescriptor.getBranchName());
    }

    private WiaUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }
}

