/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.wia;

import com.teamscale.wia.ETextValueMode;
import com.teamscale.wia.TeamscaleIssue;
import com.teamscale.wia.TeamscaleIssueId;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.OptionalLong;
import java.util.Set;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.collections.UnmodifiableList;
import org.conqat.lib.commons.date.DateTimeUtils;

public class WorkItemDescriberBase<T extends TeamscaleIssue> {
    private final Map<String, StaticValueDescriber<T>> defaultValueDescriber = new HashMap<String, StaticValueDescriber<T>>();
    public static final String PARENT_FIELD_NAME = "parent";
    private static final Set<String> TECHNICAL_KEYS_TO_FILTER = new HashSet<String>(Arrays.asList("assignee", "author", "closed", "connector", "created", "id", "status", "uniformPath", "updated", "url", "parent"));

    public WorkItemDescriberBase() {
        this.addDescriber(StaticValueDescriber.withNaturalOrder("subject", TeamscaleIssue::getSubject, String::toLowerCase));
        this.addDescriber(StaticValueDescriber.withNaturalOrder("description", TeamscaleIssue::getDescription, String::toLowerCase));
        this.addDescriber(new StaticValueDescriber<TeamscaleIssue>("id", issue -> issue.getId().getExternalId(), Comparator.comparing(TeamscaleIssue::getId, IssueIdComparator.INSTANCE)));
        this.addDescriber(StaticValueDescriber.withNaturalOrder("connector", issue1 -> issue1.getId().getConnectorId(), String::toLowerCase));
        this.addDescriber(StaticValueDescriber.withNaturalOrder("assignee", TeamscaleIssue::getAssignee, String::toLowerCase));
        this.addDescriber(StaticValueDescriber.withNaturalOrder("author", TeamscaleIssue::getAuthor, String::toLowerCase));
        this.addDescriber(new StaticValueDescriber<TeamscaleIssue>("created", issue -> WorkItemDescriberBase.timestampToDateString(issue.getCreated()), Comparator.comparingLong(TeamscaleIssue::getCreated)));
        this.addDescriber(new StaticValueDescriber<TeamscaleIssue>("updated", issue -> WorkItemDescriberBase.timestampToDateString(issue.getUpdated()), Comparator.comparingLong(TeamscaleIssue::getUpdated)));
        this.addDescriber(StaticValueDescriber.withNaturalOrder("status", TeamscaleIssue::getStatus, String::toLowerCase));
        this.addDescriber(StaticValueDescriber.withNaturalOrder("closed", issue1 -> Boolean.toString(issue1.isClosed())));
        this.addDescriber(new StaticValueDescriber<TeamscaleIssue>(PARENT_FIELD_NAME, issue -> issue.getParentId().map(TeamscaleIssueId::getExternalId).orElse(""), Comparator.comparing(issue -> issue.getParentId().orElse(null), Comparator.nullsFirst(IssueIdComparator.INSTANCE))));
    }

    protected final void addDescriber(StaticValueDescriber<T> describer) {
        CCSMAssert.isNotNull(describer, () -> String.format("Expected \"%s\" to be not null", "describer"));
        StaticValueDescriber<T> existingValue = this.defaultValueDescriber.putIfAbsent(describer.getKey().toLowerCase(), describer);
        CCSMAssert.isTrue((existingValue == null ? 1 : 0) != 0, () -> String.format("There already exists a describer for \"%s\"", describer.getKey()));
    }

    public List<String> getKeys(T issue) {
        UnmodifiableList<String> additionalFieldNames = ((TeamscaleIssue)issue).getAdditionalFieldNames();
        ArrayList<String> result = new ArrayList<String>(this.defaultValueDescriber.size() + additionalFieldNames.size());
        result.addAll(this.defaultValueDescriber.keySet());
        result.addAll((Collection<String>)additionalFieldNames);
        return result;
    }

    public @NonNull List<String> getNonTechnicalKeys(T issue) {
        List<String> filteredKeys = this.getKeys(issue);
        filteredKeys.removeAll(TECHNICAL_KEYS_TO_FILTER);
        return filteredKeys;
    }

    public IValueDescriber<T> getValueDescriber(String key) {
        StaticValueDescriber<T> valueDescriber = this.defaultValueDescriber.get(key.toLowerCase());
        if (valueDescriber != null) {
            return valueDescriber;
        }
        return new AdditionalFieldValueDescriber(key);
    }

    public BiFunction<T, ETextValueMode, String> getValueAccessor(String key) {
        return this.getValueDescriber(key).getAccessor();
    }

    public @Nullable Comparator<T> getValueComparator(String key) {
        return this.getValueDescriber(key).getComparator();
    }

    private static String timestampToDateString(long timestamp) {
        return DateTimeFormatter.ISO_LOCAL_DATE.format(Instant.ofEpochMilli(timestamp).atZone(DateTimeUtils.getZone()).toLocalDate());
    }

    public static final class StaticValueDescriber<T extends TeamscaleIssue>
    implements IValueDescriber<T> {
        private final String key;
        private final Function<T, String> accessor;
        private final @Nullable Comparator<T> comparator;

        public StaticValueDescriber(String key, Function<? super T, String> accessor, @Nullable Comparator<? super T> comparator) {
            CCSMAssert.isNotNull((Object)key, () -> String.format("Expected \"%s\" to be not null", "key"));
            CCSMAssert.isNotNull(accessor, () -> String.format("Expected \"%s\" to be not null", "accessor"));
            this.key = key;
            this.accessor = accessor;
            this.comparator = comparator;
        }

        static <T extends TeamscaleIssue> StaticValueDescriber<T> withNaturalOrder(String key, Function<T, String> accessor) {
            return StaticValueDescriber.withNaturalOrder(key, accessor, Function.identity());
        }

        static <T extends TeamscaleIssue, U extends Comparable<U>> StaticValueDescriber<T> withNaturalOrder(String key, Function<T, String> accessor, Function<String, U> translator) {
            return new StaticValueDescriber<T>(key, accessor, Comparator.comparing(accessor.andThen(translator), Comparator.nullsLast(Comparator.naturalOrder())));
        }

        @Override
        public String getExactKeyName(T item) {
            return this.getKey();
        }

        public String getKey() {
            return this.key;
        }

        @Override
        public BiFunction<T, ETextValueMode, String> getAccessor() {
            return (item, mode) -> {
                String rawValue = this.accessor.apply((TeamscaleIssue)item);
                return mode.transformText(rawValue);
            };
        }

        @Override
        public @Nullable Comparator<T> getComparator() {
            return this.comparator;
        }
    }

    public static enum IssueIdComparator implements Comparator<TeamscaleIssueId>
    {
        INSTANCE;

        private static final Pattern ISSUE_NUMBER_PATTERN;

        @Override
        public int compare(TeamscaleIssueId firstIssueId, TeamscaleIssueId secondIssueId) {
            OptionalLong optFirstIssueId = IssueIdComparator.getNumberFromIssueId(firstIssueId.getExternalId());
            OptionalLong optSecondIssueId = IssueIdComparator.getNumberFromIssueId(secondIssueId.getExternalId());
            if (optFirstIssueId.isPresent() && optSecondIssueId.isPresent()) {
                return Long.compare(optFirstIssueId.getAsLong(), optSecondIssueId.getAsLong());
            }
            if (optFirstIssueId.isPresent()) {
                return -1;
            }
            if (optSecondIssueId.isPresent()) {
                return 1;
            }
            return firstIssueId.compareTo(secondIssueId);
        }

        private static OptionalLong getNumberFromIssueId(String id) {
            if (id == null || id.isEmpty()) {
                return OptionalLong.empty();
            }
            Matcher matcher = ISSUE_NUMBER_PATTERN.matcher(id);
            if (matcher.matches()) {
                return OptionalLong.of(Long.parseLong(matcher.group(1)));
            }
            return OptionalLong.empty();
        }

        static {
            ISSUE_NUMBER_PATTERN = Pattern.compile(".*?(\\d+).*?");
        }
    }

    private static class AdditionalFieldValueDescriber<T extends TeamscaleIssue>
    implements IValueDescriber<T> {
        private final String fieldName;

        private AdditionalFieldValueDescriber(String fieldName) {
            CCSMAssert.isNotNull((Object)fieldName, () -> String.format("Expected \"%s\" to be not null", "fieldName"));
            this.fieldName = fieldName;
        }

        @Override
        public String getExactKeyName(T item) {
            return ((TeamscaleIssue)item).getAdditionalFieldNames().stream().filter(name -> name.equalsIgnoreCase(this.fieldName)).findFirst().orElse(this.fieldName);
        }

        @Override
        public BiFunction<T, ETextValueMode, String> getAccessor() {
            return (item, mode) -> mode.transformText(item.getAdditionalFieldValue(this.fieldName));
        }

        @Override
        public @Nullable Comparator<T> getComparator() {
            return null;
        }
    }

    public static interface IValueDescriber<T extends TeamscaleIssue> {
        public String getExactKeyName(T var1);

        public BiFunction<T, ETextValueMode, @Nullable String> getAccessor();

        default public @Nullable String getValue(T item, ETextValueMode mode) {
            return this.getAccessor().apply(item, mode);
        }

        public @Nullable Comparator<T> getComparator();
    }
}

