/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.env;

import java.io.Closeable;
import java.util.Map;
import jetbrains.exodus.ArrayByteIterable;
import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.bindings.LongBinding;
import jetbrains.exodus.core.dataStructures.hash.LongHashMap;
import jetbrains.exodus.env.Bitmap;
import jetbrains.exodus.env.BitmapImplKt;
import jetbrains.exodus.env.BitmapIterator;
import jetbrains.exodus.env.Cursor;
import jetbrains.exodus.env.EnvironmentImpl;
import jetbrains.exodus.env.StoreImpl;
import jetbrains.exodus.env.Transaction;
import kotlin.Metadata;
import kotlin.io.CloseableKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0016\u0018\u0000 \u001c2\u00020\u0001:\u0001\u001cB\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\u001c\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0016J\u0010\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J(\u0010\u000e\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000f\u001a\u00060\fj\u0002`\r2\n\u0010\u0010\u001a\u00060\fj\u0002`\rH\u0016J\u001d\u0010\u0011\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\rH\u0096\u0002J\r\u0010\u0012\u001a\u00070\u0013\u00a2\u0006\u0002\b\u0014H\u0016J\u0010\u0010\u0015\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0016\u001a\u00020\f2\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0017\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0016J\u0010\u0010\u0019\u001a\u00020\u00182\u0006\u0010\t\u001a\u00020\nH\u0016J%\u0010\u001a\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\n\u0010\u000b\u001a\u00060\fj\u0002`\r2\u0006\u0010\u001b\u001a\u00020\bH\u0096\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\u001d"}, d2={"Ljetbrains/exodus/env/BitmapImpl;", "Ljetbrains/exodus/env/Bitmap;", "store", "Ljetbrains/exodus/env/StoreImpl;", "(Ljetbrains/exodus/env/StoreImpl;)V", "getStore", "()Ljetbrains/exodus/env/StoreImpl;", "clear", "", "txn", "Ljetbrains/exodus/env/Transaction;", "bit", "", "Ljetbrains/exodus/env/Bit;", "count", "firstBit", "lastBit", "get", "getEnvironment", "Ljetbrains/exodus/env/EnvironmentImpl;", "Lorg/jetbrains/annotations/NotNull;", "getFirst", "getLast", "iterator", "Ljetbrains/exodus/env/BitmapIterator;", "reverseIterator", "set", "value", "Companion", "xodus-environment"})
public class BitmapImpl
implements Bitmap {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final StoreImpl store;
    private static final long ALL_ONES = -1L;
    @NotNull
    private static final LongHashMap<Integer> SINGLE_ZEROS = new LongHashMap(0, 0.0f, 3, null);
    @NotNull
    private static final LongHashMap<Integer> SINGLE_ONES = new LongHashMap(0, 0.0f, 3, null);

    public BitmapImpl(@NotNull StoreImpl store) {
        Intrinsics.checkNotNullParameter((Object)store, (String)"store");
        this.store = store;
    }

    @NotNull
    public StoreImpl getStore() {
        return this.store;
    }

    @NotNull
    public EnvironmentImpl getEnvironment() {
        EnvironmentImpl environmentImpl = this.getStore().getEnvironment();
        Intrinsics.checkNotNullExpressionValue((Object)environmentImpl, (String)"store.environment");
        return environmentImpl;
    }

    public boolean get(@NotNull Transaction txn, long bit) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        long key = BitmapImplKt.getKey(BitmapImplKt.access$ensureNonNegative(bit));
        ByteIterable byteIterable = this.getStore().get(txn, (ByteIterable)LongBinding.longToCompressedEntry((long)key));
        if (byteIterable == null) {
            return false;
        }
        ByteIterable bitmapEntry = byteIterable;
        long mask = 1L << BitmapImplKt.getIndex(bit);
        return (Companion.getAsLong$xodus_environment(bitmapEntry) & mask) != 0L;
    }

    public boolean set(@NotNull Transaction txn, long bit, boolean value) {
        boolean prevValue;
        long l;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        long key = BitmapImplKt.getKey(BitmapImplKt.access$ensureNonNegative(bit));
        ArrayByteIterable keyEntry = LongBinding.longToCompressedEntry((long)key);
        long mask = 1L << BitmapImplKt.getIndex(bit);
        ByteIterable byteIterable = this.getStore().get(txn, (ByteIterable)keyEntry);
        long bitmap = byteIterable == null ? 0L : (l = Companion.getAsLong$xodus_environment(byteIterable));
        boolean bl = prevValue = (bitmap & mask) != 0L;
        if (prevValue == value) {
            return false;
        }
        long it = bitmap ^ mask;
        boolean bl2 = false;
        boolean bl3 = it == 0L ? this.getStore().delete(txn, (ByteIterable)keyEntry) : this.getStore().put(txn, (ByteIterable)keyEntry, Companion.getAsEntry$xodus_environment(it));
        return true;
    }

    public boolean clear(@NotNull Transaction txn, long bit) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return this.set(txn, bit, false);
    }

    @NotNull
    public BitmapIterator iterator(@NotNull Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return new BitmapIterator(txn, this.getStore(), 0, 4, null);
    }

    @NotNull
    public BitmapIterator reverseIterator(@NotNull Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        return new BitmapIterator(txn, this.getStore(), -1);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getFirst(@NotNull Transaction txn) {
        long l;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Closeable closeable = this.iterator(txn);
        Throwable throwable = null;
        try {
            BitmapIterator it = (BitmapIterator)closeable;
            boolean bl = false;
            l = it.hasNext() ? it.next() : -1L;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLast(@NotNull Transaction txn) {
        long l;
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Closeable closeable = this.reverseIterator(txn);
        Throwable throwable = null;
        try {
            BitmapIterator it = (BitmapIterator)closeable;
            boolean bl = false;
            l = it.hasNext() ? it.next() : -1L;
        }
        catch (Throwable throwable2) {
            throwable = throwable2;
            throw throwable2;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
        return l;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(@NotNull Transaction txn) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        Closeable closeable = (Closeable)this.getStore().openCursor(txn);
        Throwable throwable = null;
        try {
            Cursor cursor = (Cursor)closeable;
            boolean bl = false;
            long count = 0L;
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
            Cursor $this$forEach$iv = cursor;
            boolean $i$f$forEach = false;
            Closeable closeable2 = (Closeable)$this$forEach$iv;
            Throwable throwable2 = null;
            try {
                Cursor it$iv = (Cursor)closeable2;
                boolean bl2 = false;
                while ($this$forEach$iv.getNext()) {
                    Cursor $this$count_u24lambda_u2d4_u24lambda_u2d3 = $this$forEach$iv;
                    boolean bl3 = false;
                    ByteIterable byteIterable = $this$count_u24lambda_u2d4_u24lambda_u2d3.getValue();
                    Intrinsics.checkNotNullExpressionValue((Object)byteIterable, (String)"value");
                    count += (long)BitmapImpl.Companion.getCountBits(byteIterable);
                }
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l = count;
            return l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long count(@NotNull Transaction txn, long firstBit, long lastBit) {
        Intrinsics.checkNotNullParameter((Object)txn, (String)"txn");
        if (firstBit > lastBit) {
            throw new IllegalArgumentException("firstBit > lastBit");
        }
        if (firstBit == lastBit) {
            return this.get(txn, firstBit) ? 1L : 0L;
        }
        Closeable closeable = (Closeable)this.getStore().openCursor(txn);
        Throwable throwable = null;
        try {
            ByteIterable byteIterable;
            Cursor cursor = (Cursor)closeable;
            boolean bl = false;
            long firstKey = BitmapImplKt.getKey(BitmapImplKt.access$ensureNonNegative(firstBit));
            long lastKey = BitmapImplKt.getKey(BitmapImplKt.access$ensureNonNegative(lastBit));
            ArrayByteIterable keyEntry = LongBinding.longToCompressedEntry((long)firstKey);
            if (cursor.getSearchKeyRange((ByteIterable)keyEntry) == null) {
                long l = 0L;
                return l;
            }
            ByteIterable valueEntry = byteIterable;
            Ref.LongRef count = new Ref.LongRef();
            long key = LongBinding.compressedEntryToLong((ByteIterable)cursor.getKey());
            boolean bl2 = firstKey + 1L <= key ? key < lastKey : false;
            if (bl2) {
                count.element += (long)BitmapImpl.Companion.getCountBits(valueEntry);
            } else {
                int highBit;
                long bits = Companion.getAsLong$xodus_environment(valueEntry);
                int lowBit = key == firstKey ? BitmapImplKt.getIndex(firstBit) : 0;
                int n = lowBit;
                if (n <= (highBit = key == lastKey ? BitmapImplKt.getIndex(lastBit) : 63)) {
                    int i;
                    do {
                        if ((bits & 1L << (i = n++)) == 0L) continue;
                        ++count.element;
                        long cfr_ignored_0 = count.element;
                    } while (i != highBit);
                }
            }
            Intrinsics.checkNotNullExpressionValue((Object)cursor, (String)"cursor");
            Cursor $this$forEach$iv = cursor;
            boolean $i$f$forEach = false;
            Closeable closeable2 = (Closeable)$this$forEach$iv;
            Throwable throwable2 = null;
            try {
                Cursor it$iv = (Cursor)closeable2;
                boolean bl3 = false;
                while (true) {
                    if ($this$forEach$iv.getNext()) {
                        Cursor $this$count_u24lambda_u2d6_u24lambda_u2d5 = $this$forEach$iv;
                        boolean bl4 = false;
                        long currentKey = LongBinding.compressedEntryToLong((ByteIterable)$this$count_u24lambda_u2d6_u24lambda_u2d5.getKey());
                        if (currentKey >= lastKey) {
                            if (currentKey == lastKey) {
                                ByteIterable byteIterable2 = $this$count_u24lambda_u2d6_u24lambda_u2d5.getValue();
                                Intrinsics.checkNotNullExpressionValue((Object)byteIterable2, (String)"value");
                                long bits = Companion.getAsLong$xodus_environment(byteIterable2);
                                int n = 0;
                                int n2 = BitmapImplKt.getIndex(lastBit);
                                if (n <= n2) {
                                    int i;
                                    do {
                                        if ((bits & 1L << (i = n++)) == 0L) continue;
                                        ++count.element;
                                        long cfr_ignored_1 = count.element;
                                    } while (i != n2);
                                }
                            }
                            long l = count.element;
                            long l2 = l;
                            return l2;
                        }
                        long l = count.element;
                        ByteIterable byteIterable3 = $this$count_u24lambda_u2d6_u24lambda_u2d5.getValue();
                        Intrinsics.checkNotNullExpressionValue((Object)byteIterable3, (String)"value");
                        count.element = l + (long)BitmapImpl.Companion.getCountBits(byteIterable3);
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable throwable3) {
                throwable2 = throwable3;
                throw throwable3;
            }
            finally {
                CloseableKt.closeFinally((Closeable)closeable2, (Throwable)throwable2);
            }
            long l = count.element;
            return l;
        }
        catch (Throwable throwable4) {
            throwable = throwable4;
            throw throwable4;
        }
        finally {
            CloseableKt.closeFinally((Closeable)closeable, (Throwable)throwable);
        }
    }

    static {
        long bit = 1L;
        int n = 0;
        while (n < 64) {
            int i = n++;
            Map map = (Map)SINGLE_ONES;
            Long l = bit;
            Integer n2 = i;
            map.put(l, n2);
            map = (Map)SINGLE_ZEROS;
            l = 0xFFFFFFFFFFFFFFFFL ^ bit;
            n2 = i;
            map.put(l, n2);
            bit <<= 1;
        }
    }

    @Metadata(mv={1, 6, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\t\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0018\u0010\t\u001a\u00020\n*\u00020\u00048@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0018\u0010\r\u001a\u00020\u0004*\u00020\n8@X\u0080\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000fR\u0018\u0010\u0010\u001a\u00020\u0007*\u00020\n8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006\u0013"}, d2={"Ljetbrains/exodus/env/BitmapImpl$Companion;", "", "()V", "ALL_ONES", "", "SINGLE_ONES", "Ljetbrains/exodus/core/dataStructures/hash/LongHashMap;", "", "SINGLE_ZEROS", "asEntry", "Ljetbrains/exodus/ByteIterable;", "getAsEntry$xodus_environment", "(J)Ljetbrains/exodus/ByteIterable;", "asLong", "getAsLong$xodus_environment", "(Ljetbrains/exodus/ByteIterable;)J", "countBits", "getCountBits", "(Ljetbrains/exodus/ByteIterable;)I", "xodus-environment"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ByteIterable getAsEntry$xodus_environment(long $this$asEntry) {
            if ($this$asEntry == -1L) {
                byte[] byArray = new byte[]{0};
                return (ByteIterable)new ArrayByteIterable(byArray);
            }
            Integer n = (Integer)SINGLE_ONES.get((Object)$this$asEntry);
            if (n != null) {
                int bit = ((Number)n).intValue();
                boolean bl = false;
                byte[] byArray = new byte[]{(byte)(bit + 1)};
                return (ByteIterable)new ArrayByteIterable(byArray);
            }
            Integer n2 = (Integer)SINGLE_ZEROS.get((Object)$this$asEntry);
            if (n2 != null) {
                int bit = ((Number)n2).intValue();
                boolean bl = false;
                byte[] byArray = new byte[]{(byte)(bit + 64 + 1)};
                return (ByteIterable)new ArrayByteIterable(byArray);
            }
            ArrayByteIterable arrayByteIterable = LongBinding.longToEntry((long)$this$asEntry);
            Intrinsics.checkNotNullExpressionValue((Object)arrayByteIterable, (String)"longToEntry(this)");
            return (ByteIterable)arrayByteIterable;
        }

        public final long getAsLong$xodus_environment(@NotNull ByteIterable $this$asLong) {
            Intrinsics.checkNotNullParameter((Object)$this$asLong, (String)"<this>");
            if ($this$asLong.getLength() != 1) {
                return LongBinding.entryToLong((ByteIterable)$this$asLong);
            }
            int tag = BitmapImplKt.access$getUnsigned($this$asLong.iterator().next());
            boolean bl = false;
            return tag == 0 ? -1L : (tag < 65 ? 1L << tag - 1 : 0xFFFFFFFFFFFFFFFFL ^ 1L << tag - 64 - 1);
        }

        private final int getCountBits(ByteIterable $this$countBits) {
            ByteIterator it = $this$countBits.iterator();
            boolean bl = false;
            if ($this$countBits.getLength() == 1) {
                int tag = BitmapImplKt.access$getUnsigned(it.next());
                boolean bl2 = false;
                return tag == 0 ? 64 : (tag < 65 ? 1 : 63);
            }
            int size = 0;
            size += Integer.bitCount(BitmapImplKt.access$getUnsigned(it.next()) ^ 0x80);
            while (it.hasNext()) {
                size += Integer.bitCount(BitmapImplKt.access$getUnsigned(it.next()));
            }
            return size;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

