/*
 * Decompiled with CFR 0.152.
 */
package jetbrains.exodus.tree.patricia;

import jetbrains.exodus.ByteIterable;
import jetbrains.exodus.ByteIterableBase;
import jetbrains.exodus.ByteIterator;
import jetbrains.exodus.ExodusException;
import org.jetbrains.annotations.NotNull;

final class UnEscapingByteIterable
extends ByteIterableBase {
    @NotNull
    private final ByteIterable origin;

    UnEscapingByteIterable(@NotNull ByteIterable origin) {
        this.origin = origin;
    }

    protected ByteIterator getIterator() {
        return new ByteIterator(){
            private final ByteIterator originIt;
            {
                this.originIt = UnEscapingByteIterable.this.origin.iterator();
            }

            public boolean hasNext() {
                return this.originIt.hasNext();
            }

            public byte next() {
                byte nextByte = this.originIt.next();
                if (nextByte == 1) {
                    if (!this.originIt.hasNext()) {
                        throw new ExodusException("No byte follows escaping byte");
                    }
                    nextByte = (byte)(this.originIt.next() - 1);
                }
                return nextByte;
            }

            public long skip(long bytes) {
                throw new UnsupportedOperationException();
            }
        };
    }
}

