/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.reportparser.parser;

import com.teamscale.reportparser.CoverageReportParserBase;
import com.teamscale.reportparser.parser.ReportParserException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Set;
import org.conqat.engine.sourcecode.coverage.CoverageInfoRetriever;
import org.conqat.engine.sourcecode.coverage.ELineCoverage;
import org.conqat.engine.sourcecode.coverage.LineCoverageInfo;
import org.conqat.lib.commons.xml.XMLUtils;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class LauterbachTrace32CoverageReportParser
extends CoverageReportParserBase {
    @Override
    public void parseCoverageReport(String report, CoverageInfoRetriever retriever) throws ReportParserException {
        try {
            XMLUtils.parseSAX((String)report, (DefaultHandler)new LauterbachTrace32ReportHanlder(retriever));
        }
        catch (IOException | SAXException e) {
            throw new ReportParserException(e);
        }
    }

    private static class LauterbachTrace32ReportHanlder
    extends DefaultHandler {
        private static final String OBJECT_CODE_NEVER_COVERED_TAG = "never";
        private static final Set<String> COVERED_TAGS = Set.of("ok", "stmt", "dc", "stmt+dc", "cc", "mc/dc", "func", "call");
        private static final String LIST_ELEMENT = "List.EXPORT";
        private static final String MIXED_ELEMENT = "mixed";
        private static final String HLL_ELEMENT = "hll";
        private static final String ASM_ELEMENT = "asm";
        private static final String COVERAGE_ELEMENT = "cov";
        private static final String LINE_ELEMENT = "line";
        private final CoverageInfoRetriever retriever;
        private boolean inListExportElement = false;
        private LineCoverageInfo lineCoverageInfo;
        private boolean inCovElement = false;
        private boolean inLineElement = false;
        private boolean inHllElement = false;
        private boolean inAsmElement = false;
        private String sourceCodeCoverageTag = null;
        private final List<String> objectCodeCoverageTags = new ArrayList<String>();
        private int currentLine = -1;

        private LauterbachTrace32ReportHanlder(CoverageInfoRetriever retriever) {
            this.retriever = retriever;
        }

        private boolean inMixedElement() {
            return this.lineCoverageInfo != null;
        }

        @Override
        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            switch (localName) {
                case "List.EXPORT": {
                    LOGGER.info("Trace32 version: {}", (Object)attributes.getValue("t32ver"));
                    this.inListExportElement = true;
                    break;
                }
                case "mixed": {
                    if (!this.inListExportElement) break;
                    String sourcePath = attributes.getValue("srcpath");
                    if (sourcePath != null) {
                        this.lineCoverageInfo = this.retriever.getOrCreateLineCoverageInfo(sourcePath);
                        break;
                    }
                    LOGGER.warn("Encountered mixed element in report which is missing the 'srcpath' attribute.");
                    break;
                }
                case "hll": {
                    if (!this.inMixedElement()) break;
                    this.inHllElement = true;
                    break;
                }
                case "asm": {
                    if (!this.inMixedElement()) break;
                    this.inAsmElement = true;
                    break;
                }
                case "cov": {
                    if (!this.inAsmElement && !this.inHllElement) break;
                    this.inCovElement = true;
                    break;
                }
                case "line": {
                    if (!this.inHllElement) break;
                    this.inLineElement = true;
                    break;
                }
            }
        }

        @Override
        public void endElement(String uri, String localName, String qName) throws SAXException {
            switch (localName) {
                case "List.EXPORT": {
                    this.inListExportElement = false;
                    break;
                }
                case "mixed": {
                    if (!this.inListExportElement) break;
                    if (this.sourceCodeCoverageTag != null) {
                        this.addLineCoverageForCurrentLine();
                    }
                    this.lineCoverageInfo = null;
                    break;
                }
                case "hll": {
                    if (!this.inMixedElement()) break;
                    this.inHllElement = false;
                    break;
                }
                case "asm": {
                    if (!this.inMixedElement()) break;
                    this.inAsmElement = false;
                    break;
                }
                case "cov": {
                    if (!this.inAsmElement && !this.inHllElement) break;
                    this.inCovElement = false;
                    break;
                }
                case "line": {
                    if (!this.inHllElement) break;
                    this.inLineElement = false;
                    break;
                }
            }
        }

        @Override
        public void characters(char[] fullReport, int start, int length) {
            if (this.inHllElement) {
                if (this.inCovElement) {
                    this.sourceCodeCoverageTag = LauterbachTrace32ReportHanlder.getContent(fullReport, start, length);
                } else if (this.inLineElement) {
                    this.currentLine = Integer.parseInt(LauterbachTrace32ReportHanlder.getContent(fullReport, start, length));
                }
                return;
            }
            if (this.inAsmElement && this.inCovElement) {
                this.objectCodeCoverageTags.add(LauterbachTrace32ReportHanlder.getContent(fullReport, start, length));
            }
        }

        private static String getContent(char[] fullReport, int start, int length) {
            char[] content = Arrays.copyOfRange(fullReport, start, start + length);
            return String.valueOf(content);
        }

        private void addLineCoverageForCurrentLine() {
            this.lineCoverageInfo.addLineCoverage(this.currentLine, LauterbachTrace32ReportHanlder.getLineCoverageType(this.sourceCodeCoverageTag, this.objectCodeCoverageTags));
            this.sourceCodeCoverageTag = null;
            this.objectCodeCoverageTags.clear();
        }

        private static ELineCoverage getLineCoverageType(String sourceCodeCoverageTag, List<String> objectCodeCoverageTags) {
            if (COVERED_TAGS.contains(sourceCodeCoverageTag)) {
                return ELineCoverage.FULLY_COVERED;
            }
            if (objectCodeCoverageTags.stream().anyMatch(objectCodeCoverageTag -> !OBJECT_CODE_NEVER_COVERED_TAG.equals(objectCodeCoverageTag))) {
                return ELineCoverage.PARTIALLY_COVERED;
            }
            return ELineCoverage.NOT_COVERED;
        }
    }
}

