/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.diagnostics;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.google.common.collect.Lists;
import org.jetbrains.kotlin.com.intellij.lang.ASTNode;
import org.jetbrains.kotlin.com.intellij.openapi.application.ApplicationManager;
import org.jetbrains.kotlin.com.intellij.openapi.editor.Document;
import org.jetbrains.kotlin.com.intellij.openapi.util.TextRange;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.PsiFile;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.diagnostics.Diagnostic;
import org.jetbrains.kotlin.diagnostics.PsiDiagnosticUtils;
import org.jetbrains.kotlin.diagnostics.Severity;
import org.jetbrains.kotlin.psi.psiUtil.PsiUtilsKt;
import org.jetbrains.kotlin.resolve.DescriptorToSourceUtils;
import org.jetbrains.kotlin.resolve.diagnostics.Diagnostics;

public class DiagnosticUtils {
    @NotNull
    public static final Comparator<TextRange> TEXT_RANGE_COMPARATOR = (o1, o2) -> {
        if (o1.getStartOffset() != o2.getStartOffset()) {
            return o1.getStartOffset() - o2.getStartOffset();
        }
        return o1.getEndOffset() - o2.getEndOffset();
    };

    private DiagnosticUtils() {
    }

    public static String atLocation(DeclarationDescriptor descriptor2) {
        PsiElement element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2);
        if (element == null) {
            element = DescriptorToSourceUtils.descriptorToDeclaration(descriptor2.getOriginal());
        }
        if (element == null && descriptor2 instanceof ASTNode) {
            element = PsiUtilsKt.closestPsiElement((ASTNode)((Object)descriptor2));
        }
        if (element != null) {
            return PsiDiagnosticUtils.atLocation(element);
        }
        return "unknown location";
    }

    @NotNull
    public static PsiFile getContainingFile(@NotNull ASTNode node) {
        if (node == null) {
            DiagnosticUtils.$$$reportNull$$$0(0);
        }
        PsiElement closestPsiElement = PsiUtilsKt.closestPsiElement(node);
        assert (closestPsiElement != null) : "This node is not contained by a file";
        PsiFile psiFile = closestPsiElement.getContainingFile();
        if (psiFile == null) {
            DiagnosticUtils.$$$reportNull$$$0(1);
        }
        return psiFile;
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumn getLineAndColumn(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            DiagnosticUtils.$$$reportNull$$$0(2);
        }
        PsiFile file2 = diagnostic.getPsiFile();
        List<TextRange> textRanges = diagnostic.getTextRanges();
        if (textRanges.isEmpty()) {
            PsiDiagnosticUtils.LineAndColumn lineAndColumn = PsiDiagnosticUtils.LineAndColumn.NONE;
            if (lineAndColumn == null) {
                DiagnosticUtils.$$$reportNull$$$0(3);
            }
            return lineAndColumn;
        }
        TextRange firstRange = DiagnosticUtils.firstRange(textRanges);
        return DiagnosticUtils.getLineAndColumnInPsiFile(file2, firstRange);
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumn getLineAndColumnInPsiFile(PsiFile file2, TextRange range) {
        Document document = file2.getViewProvider().getDocument();
        PsiDiagnosticUtils.LineAndColumn lineAndColumn = PsiDiagnosticUtils.offsetToLineAndColumn(document, range.getStartOffset());
        if (lineAndColumn == null) {
            DiagnosticUtils.$$$reportNull$$$0(4);
        }
        return lineAndColumn;
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumnRange getLineAndColumnRange(@NotNull Diagnostic diagnostic) {
        if (diagnostic == null) {
            DiagnosticUtils.$$$reportNull$$$0(5);
        }
        PsiFile file2 = diagnostic.getPsiFile();
        List<TextRange> textRanges = diagnostic.getTextRanges();
        return DiagnosticUtils.getLineAndColumnRange(file2, textRanges);
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumnRange getLineAndColumnRange(PsiFile file2, List<TextRange> textRanges) {
        if (textRanges.isEmpty()) {
            PsiDiagnosticUtils.LineAndColumnRange lineAndColumnRange = PsiDiagnosticUtils.LineAndColumnRange.NONE;
            if (lineAndColumnRange == null) {
                DiagnosticUtils.$$$reportNull$$$0(6);
            }
            return lineAndColumnRange;
        }
        TextRange firstRange = DiagnosticUtils.firstRange(textRanges);
        return DiagnosticUtils.getLineAndColumnRangeInPsiFile(file2, firstRange);
    }

    @NotNull
    public static PsiDiagnosticUtils.LineAndColumnRange getLineAndColumnRangeInPsiFile(PsiFile file2, TextRange range) {
        Document document = file2.getViewProvider().getDocument();
        return new PsiDiagnosticUtils.LineAndColumnRange(PsiDiagnosticUtils.offsetToLineAndColumn(document, range.getStartOffset()), PsiDiagnosticUtils.offsetToLineAndColumn(document, range.getEndOffset()));
    }

    public static void throwIfRunningOnServer(Throwable e) {
        if (System.getProperty("kotlin.running.in.server.mode", "false").equals("true") || ApplicationManager.getApplication().isUnitTestMode()) {
            if (e instanceof RuntimeException) {
                throw (RuntimeException)e;
            }
            if (e instanceof Error) {
                throw (Error)e;
            }
            throw new RuntimeException(e);
        }
    }

    @NotNull
    public static TextRange firstRange(@NotNull List<TextRange> ranges) {
        if (ranges == null) {
            DiagnosticUtils.$$$reportNull$$$0(7);
        }
        TextRange textRange2 = Collections.min(ranges, TEXT_RANGE_COMPARATOR);
        if (textRange2 == null) {
            DiagnosticUtils.$$$reportNull$$$0(8);
        }
        return textRange2;
    }

    @NotNull
    public static List<Diagnostic> sortedDiagnostics(@NotNull Collection<Diagnostic> diagnostics2) {
        if (diagnostics2 == null) {
            DiagnosticUtils.$$$reportNull$$$0(9);
        }
        ArrayList<Diagnostic> result2 = Lists.newArrayList(diagnostics2);
        result2.sort((d1, d2) -> {
            TextRange range2;
            String path2;
            PsiFile file1 = d1.getPsiFile();
            PsiFile file2 = d2.getPsiFile();
            String path1 = file1.getViewProvider().getVirtualFile().getPath();
            if (!path1.equals(path2 = file2.getViewProvider().getVirtualFile().getPath())) {
                return path1.compareTo(path2);
            }
            TextRange range1 = DiagnosticUtils.firstRange(d1.getTextRanges());
            if (!range1.equals(range2 = DiagnosticUtils.firstRange(d2.getTextRanges()))) {
                return TEXT_RANGE_COMPARATOR.compare(range1, range2);
            }
            return d1.getFactory().getName().compareTo(d2.getFactory().getName());
        });
        ArrayList<Diagnostic> arrayList = result2;
        if (arrayList == null) {
            DiagnosticUtils.$$$reportNull$$$0(10);
        }
        return arrayList;
    }

    public static boolean hasError(Diagnostics diagnostics2) {
        for (Diagnostic diagnostic : diagnostics2.all()) {
            if (diagnostic.getSeverity() != Severity.ERROR) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "node";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/diagnostics/DiagnosticUtils";
                break;
            }
            case 2: 
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostic";
                break;
            }
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "ranges";
                break;
            }
            case 9: {
                objectArray2 = objectArray3;
                objectArray3[0] = "diagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/diagnostics/DiagnosticUtils";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getContainingFile";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineAndColumn";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineAndColumnInPsiFile";
                break;
            }
            case 6: {
                objectArray = objectArray2;
                objectArray2[1] = "getLineAndColumnRange";
                break;
            }
            case 8: {
                objectArray = objectArray2;
                objectArray2[1] = "firstRange";
                break;
            }
            case 10: {
                objectArray = objectArray2;
                objectArray2[1] = "sortedDiagnostics";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "getContainingFile";
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                break;
            }
            case 2: {
                objectArray = objectArray;
                objectArray[2] = "getLineAndColumn";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getLineAndColumnRange";
                break;
            }
            case 7: {
                objectArray = objectArray;
                objectArray[2] = "firstRange";
                break;
            }
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "sortedDiagnostics";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 3: 
            case 4: 
            case 6: 
            case 8: 
            case 10: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

