/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.load.java.structure.impl;

import java.util.List;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMemberValue;
import org.jetbrains.kotlin.com.intellij.psi.PsiAnnotationMethod;
import org.jetbrains.kotlin.com.intellij.psi.PsiMethod;
import org.jetbrains.kotlin.load.java.structure.JavaAnnotationArgument;
import org.jetbrains.kotlin.load.java.structure.JavaMethod;
import org.jetbrains.kotlin.load.java.structure.JavaType;
import org.jetbrains.kotlin.load.java.structure.JavaTypeParameter;
import org.jetbrains.kotlin.load.java.structure.JavaValueParameter;
import org.jetbrains.kotlin.load.java.structure.impl.JavaAnnotationArgumentImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaElementCollectionFromPsiArrayUtil;
import org.jetbrains.kotlin.load.java.structure.impl.JavaMemberImpl;
import org.jetbrains.kotlin.load.java.structure.impl.JavaTypeImpl;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementPsiSource;
import org.jetbrains.kotlin.load.java.structure.impl.source.JavaElementSourceFactory;
import org.jetbrains.kotlin.name.Name;

public class JavaMethodImpl
extends JavaMemberImpl<PsiMethod>
implements JavaMethod {
    public JavaMethodImpl(@NotNull JavaElementPsiSource<PsiMethod> psiMethodSource) {
        if (psiMethodSource == null) {
            JavaMethodImpl.$$$reportNull$$$0(0);
        }
        super(psiMethodSource);
        PsiMethod method = psiMethodSource.getPsi();
        assert (!method.isConstructor()) : "PsiMethod which is a constructor should be wrapped in JavaConstructorImpl: " + method.getName();
    }

    public JavaMethodImpl(PsiMethod psiMethod) {
        this(JavaElementSourceFactory.getInstance(psiMethod.getProject()).createPsiSource(psiMethod));
    }

    @Override
    @NotNull
    public Name getName() {
        Name name = Name.identifier(((PsiMethod)this.getPsi()).getName());
        if (name == null) {
            JavaMethodImpl.$$$reportNull$$$0(1);
        }
        return name;
    }

    @Override
    @NotNull
    public List<JavaTypeParameter> getTypeParameters() {
        List<JavaTypeParameter> list2 = JavaElementCollectionFromPsiArrayUtil.typeParameters(((PsiMethod)this.getPsi()).getTypeParameters(), this.getSourceFactory());
        if (list2 == null) {
            JavaMethodImpl.$$$reportNull$$$0(2);
        }
        return list2;
    }

    @Override
    @NotNull
    public List<JavaValueParameter> getValueParameters() {
        List<JavaValueParameter> list2 = JavaElementCollectionFromPsiArrayUtil.valueParameters(((PsiMethod)this.getPsi()).getParameterList().getParameters(), this.getSourceFactory());
        if (list2 == null) {
            JavaMethodImpl.$$$reportNull$$$0(3);
        }
        return list2;
    }

    @Override
    @Nullable
    public JavaAnnotationArgument getAnnotationParameterDefaultValue() {
        PsiAnnotationMemberValue defaultValue;
        PsiMethod psiMethod = (PsiMethod)this.getPsi();
        if (psiMethod instanceof PsiAnnotationMethod && (defaultValue = ((PsiAnnotationMethod)psiMethod).getDefaultValue()) != null) {
            return JavaAnnotationArgumentImpl.Factory.create(defaultValue, null, this.getSourceFactory());
        }
        return null;
    }

    @Override
    public boolean getHasAnnotationParameterDefaultValue() {
        PsiMethod psiMethod = (PsiMethod)this.getPsi();
        return psiMethod instanceof PsiAnnotationMethod && ((PsiAnnotationMethod)psiMethod).getDefaultValue() != null;
    }

    @Override
    @NotNull
    public JavaType getReturnType() {
        JavaTypeImpl<?> javaTypeImpl = JavaTypeImpl.create(Objects.requireNonNull(((PsiMethod)this.getPsi()).getReturnType()), this.createMethodReturnTypeSource(this.psiElementSource));
        if (javaTypeImpl == null) {
            JavaMethodImpl.$$$reportNull$$$0(4);
        }
        return javaTypeImpl;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "psiMethodSource";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "org/jetbrains/kotlin/load/java/structure/impl/JavaMethodImpl";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getName";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "getTypeParameters";
                break;
            }
            case 3: {
                objectArray = objectArray2;
                objectArray2[1] = "getValueParameters";
                break;
            }
            case 4: {
                objectArray = objectArray2;
                objectArray2[1] = "getReturnType";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

