/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtClass;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.InterfaceCouldBeFunctionalCheckKt;

@Rule(key="S6517")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\n\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000b"}, d2={"Lorg/sonarsource/kotlin/checks/InterfaceCouldBeFunctionalCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "checkFunctionalInterface", "", "klass", "Lorg/jetbrains/kotlin/psi/KtClass;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "checkFunctionalInterfaceAnnotation", "visitClass", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nInterfaceCouldBeFunctionalCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 InterfaceCouldBeFunctionalCheck.kt\norg/sonarsource/kotlin/checks/InterfaceCouldBeFunctionalCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,75:1\n1855#2,2:76\n*S KotlinDebug\n*F\n+ 1 InterfaceCouldBeFunctionalCheck.kt\norg/sonarsource/kotlin/checks/InterfaceCouldBeFunctionalCheck\n*L\n52#1:76,2\n*E\n"})
public final class InterfaceCouldBeFunctionalCheck
extends AbstractCheck {
    @Override
    public void visitClass(@NotNull KtClass klass, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(klass, "klass");
        Intrinsics.checkNotNullParameter(context, "context");
        this.checkFunctionalInterface(klass, context);
        this.checkFunctionalInterfaceAnnotation(klass, context);
    }

    private final void checkFunctionalInterface(KtClass klass, KotlinFileContext context) {
        boolean isNonFunctionalInterface;
        boolean bl = isNonFunctionalInterface = klass.isInterface() && klass.getFunKeyword() == null;
        if (isNonFunctionalInterface && InterfaceCouldBeFunctionalCheckKt.access$hasExactlyOneFunctionAndNoProperties(klass) && !klass.isSealed()) {
            AbstractCheck abstractCheck = this;
            PsiElement psiElement = klass.getClassOrInterfaceKeyword();
            Intrinsics.checkNotNull(psiElement);
            AbstractCheck.reportIssue$default(abstractCheck, context, psiElement, "Make this interface functional or replace it with a function type.", null, null, 12, null);
        }
    }

    private final void checkFunctionalInterfaceAnnotation(KtClass klass, KotlinFileContext context) {
        List<KtAnnotationEntry> list2 = klass.getAnnotationEntries();
        Intrinsics.checkNotNullExpressionValue(list2, "getAnnotationEntries(...)");
        Iterable $this$forEach$iv = list2;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            KtAnnotationEntry it = (KtAnnotationEntry)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull(it);
            if (!InterfaceCouldBeFunctionalCheckKt.access$isFunctionalInterfaceAnnotation(it, context)) continue;
            AbstractCheck.reportIssue$default((AbstractCheck)this, context, (PsiElement)it, "\"@FunctionalInterface\" annotation has no effect in Kotlin", null, null, 12, null);
        }
    }
}

