/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.checks;

import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.com.intellij.psi.PsiElement;
import org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement;
import org.jetbrains.kotlin.psi.KtExpression;
import org.jetbrains.kotlin.psi.KtIfExpression;
import org.jetbrains.kotlin.psi.KtWhenEntry;
import org.jetbrains.kotlin.psi.KtWhenExpression;
import org.sonar.check.Rule;
import org.sonarsource.kotlin.api.checks.AbstractCheck;
import org.sonarsource.kotlin.api.checks.ApiExtensionsKt;
import org.sonarsource.kotlin.api.frontend.KotlinFileContext;
import org.sonarsource.kotlin.checks.LiftReturnStatementCheckKt;

@Rule(key="S6510")
@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000,\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0007\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0018\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\bH\u0002J\u0018\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u0007\u001a\u00020\bH\u0016J\u0018\u0010\f\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\bH\u0016\u00a8\u0006\u000e"}, d2={"Lorg/sonarsource/kotlin/checks/LiftReturnStatementCheck;", "Lorg/sonarsource/kotlin/api/checks/AbstractCheck;", "()V", "reportIssue", "", "keywordElement", "Lorg/jetbrains/kotlin/com/intellij/psi/PsiElement;", "context", "Lorg/sonarsource/kotlin/api/frontend/KotlinFileContext;", "visitIfExpression", "expression", "Lorg/jetbrains/kotlin/psi/KtIfExpression;", "visitWhenExpression", "Lorg/jetbrains/kotlin/psi/KtWhenExpression;", "sonar-kotlin-checks"})
@SourceDebugExtension(value={"SMAP\nLiftReturnStatementCheck.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LiftReturnStatementCheck.kt\norg/sonarsource/kotlin/checks/LiftReturnStatementCheck\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,69:1\n1726#2,3:70\n*S KotlinDebug\n*F\n+ 1 LiftReturnStatementCheck.kt\norg/sonarsource/kotlin/checks/LiftReturnStatementCheck\n*L\n47#1:70,3\n*E\n"})
public final class LiftReturnStatementCheck
extends AbstractCheck {
    @Override
    public void visitIfExpression(@NotNull KtIfExpression expression2, @NotNull KotlinFileContext context) {
        Intrinsics.checkNotNullParameter(expression2, "expression");
        Intrinsics.checkNotNullParameter(context, "context");
        KtExpression ktExpression = expression2.getThen();
        Intrinsics.checkNotNull(ktExpression);
        KtExpression thenBranch = ktExpression;
        KtExpression ktExpression2 = expression2.getElse();
        if (ktExpression2 == null) {
            return;
        }
        KtExpression elseBranch = ktExpression2;
        if (LiftReturnStatementCheckKt.access$isReturnOrReturnBlock(thenBranch) && LiftReturnStatementCheckKt.access$isReturnOrReturnBlock(elseBranch)) {
            PsiElement psiElement = expression2.getIfKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getIfKeyword(...)");
            this.reportIssue(psiElement, context);
        }
    }

    @Override
    public void visitWhenExpression(@NotNull KtWhenExpression expression2, @NotNull KotlinFileContext context) {
        boolean isAllBranchesReturn;
        block4: {
            boolean bl;
            Intrinsics.checkNotNullParameter(expression2, "expression");
            Intrinsics.checkNotNullParameter(context, "context");
            List<KtWhenEntry> list2 = expression2.getEntries();
            Intrinsics.checkNotNullExpressionValue(list2, "getEntries(...)");
            Iterable $this$all$iv = list2;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    KtWhenEntry it = (KtWhenEntry)element$iv;
                    boolean bl2 = false;
                    KtExpression ktExpression = it.getExpression();
                    Intrinsics.checkNotNull(ktExpression);
                    if (LiftReturnStatementCheckKt.access$isReturnOrReturnBlock(ktExpression)) continue;
                    bl = false;
                    break block4;
                }
                bl = isAllBranchesReturn = true;
            }
        }
        if (isAllBranchesReturn && ApiExtensionsKt.isExhaustive(expression2, context)) {
            PsiElement psiElement = expression2.getWhenKeyword();
            Intrinsics.checkNotNullExpressionValue(psiElement, "getWhenKeyword(...)");
            this.reportIssue(psiElement, context);
        }
    }

    private final void reportIssue(PsiElement keywordElement, KotlinFileContext context) {
        Intrinsics.checkNotNull(keywordElement, "null cannot be cast to non-null type org.jetbrains.kotlin.com.intellij.psi.impl.source.tree.LeafPsiElement");
        CharSequence charSequence = ((LeafPsiElement)keywordElement).getChars();
        Intrinsics.checkNotNullExpressionValue(charSequence, "getChars(...)");
        CharSequence keyword = charSequence;
        AbstractCheck.reportIssue$default((AbstractCheck)this, context, keywordElement, "Move \"return\" statements from all branches before \"" + keyword + "\" statement.", null, null, 12, null);
    }
}

