/*
 * Decompiled with CFR 0.152.
 */
package org.sonarsource.kotlin.surefire.data;

import java.util.UUID;

public final class UnitTestResult {
    public static final String STATUS_OK = "ok";
    public static final String STATUS_ERROR = "error";
    public static final String STATUS_FAILURE = "failure";
    public static final String STATUS_SKIPPED = "skipped";
    private String name = UUID.randomUUID().toString();
    private String testSuiteClassName;
    private String status;
    private long durationMilliseconds = 0L;

    public String getName() {
        return this.name;
    }

    public UnitTestResult setName(String name) {
        this.name = name;
        return this;
    }

    public String getStatus() {
        return this.status;
    }

    public UnitTestResult setStatus(String status2) {
        this.status = status2;
        return this;
    }

    public long getDurationMilliseconds() {
        return this.durationMilliseconds;
    }

    public UnitTestResult setDurationMilliseconds(long l) {
        this.durationMilliseconds = l;
        return this;
    }

    public boolean isErrorOrFailure() {
        return STATUS_ERROR.equals(this.status) || STATUS_FAILURE.equals(this.status);
    }

    public boolean isError() {
        return STATUS_ERROR.equals(this.status);
    }

    public UnitTestResult setTestSuiteClassName(String testSuiteClassName) {
        this.testSuiteClassName = testSuiteClassName;
        return this;
    }

    public String getTestSuiteClassName() {
        return this.testSuiteClassName;
    }
}

