/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.service.framework.impl.handler;

import jakarta.servlet.Filter;
import jakarta.servlet.FilterChain;
import jakarta.servlet.FilterConfig;
import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.ServletResponse;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.concurrent.atomic.AtomicInteger;

public class InFlightRequestFilter
implements Filter {
    private volatile boolean blockNewRequests = false;
    private AtomicInteger activeRequestCount = new AtomicInteger();
    private static final String CONTROL_PATH = "/api/test-state-reset";

    public void init(FilterConfig filterConfig) throws ServletException {
        this.blockNewRequests = false;
        this.activeRequestCount = new AtomicInteger();
    }

    public void blockNewRequests() {
        this.blockNewRequests = true;
    }

    public void unblockNewRequests() {
        this.blockNewRequests = false;
    }

    public void waitForActiveRequestsToComplete() throws InterruptedException {
        while (this.activeRequestCount.get() > 0) {
            Thread.sleep(100L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        HttpServletRequest httpRequest = (HttpServletRequest)request;
        HttpServletResponse httpResponse = (HttpServletResponse)response;
        String requestPath = httpRequest.getRequestURI();
        boolean isControlRequest = requestPath.contains(CONTROL_PATH);
        if (this.blockNewRequests && !isControlRequest) {
            httpResponse.sendError(503, "Server is processing pending requests and cannot accept new requests at this time.");
            return;
        }
        if (!isControlRequest) {
            this.activeRequestCount.incrementAndGet();
        }
        try {
            chain.doFilter(request, response);
        }
        finally {
            if (!isControlRequest) {
                this.activeRequestCount.decrementAndGet();
            }
        }
    }
}

