/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.commons.service;

import com.ctc.wstx.api.InvalidCharHandler;
import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.MapperFeature;
import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.type.TypeFactory;
import com.fasterxml.jackson.dataformat.xml.XmlMapper;
import com.fasterxml.jackson.module.jakarta.xmlbind.JakartaXmlBindAnnotationModule;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.conqat.engine.commons.util.JsonUtils;
import org.conqat.lib.commons.assertion.CCSMAssert;
import org.conqat.lib.commons.string.StringUtils;
import org.conqat.lib.commons.utils.UtilsInstantiationNotSupportedException;

public final class XmlSerializationUtils {
    private static final XmlMapper XML_MAPPER = (XmlMapper)((XmlMapper.Builder)((XmlMapper.Builder)((XmlMapper.Builder)XmlMapper.builder().enable(new MapperFeature[]{MapperFeature.ACCEPT_CASE_INSENSITIVE_ENUMS})).disable(new DeserializationFeature[]{DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES})).visibility(PropertyAccessor.FIELD, JsonAutoDetect.Visibility.ANY)).build();

    public static String serializeToXML(Object object) {
        try {
            return XML_MAPPER.writeValueAsString(object);
        }
        catch (JsonProcessingException e) {
            throw new JsonUtils.JsonSerializationRuntimeException(e);
        }
    }

    public static <T> T deserializeFromXML(String xml, Class<T> expectedClass) throws IOException {
        if (Map.class.isAssignableFrom(expectedClass) || Collection.class.isAssignableFrom(expectedClass)) {
            CCSMAssert.fail((String)"Tried to deserialize with a Collection/Map class. This will fail if the elements of the class (generic types) are any other than String. Construct and pass a more detailed JavaType instead.");
        }
        return XmlSerializationUtils.deserializeFromXML(xml, TypeFactory.defaultInstance().constructType(expectedClass));
    }

    public static <T> T deserializeFromXML(String xml, JavaType expectedType) throws IOException {
        return (T)XML_MAPPER.readValue(xml, expectedType);
    }

    public static JsonNode parseXmlToJsonNode(String xml) throws IOException {
        return XML_MAPPER.readTree(StringUtils.stringToBytes((String)xml));
    }

    private XmlSerializationUtils() {
        throw new UtilsInstantiationNotSupportedException();
    }

    static {
        XML_MAPPER.registerModule((Module)new JakartaXmlBindAnnotationModule());
        if (XML_MAPPER.getFactory().getXMLOutputFactory().isPropertySupported("com.ctc.wstx.outputInvalidCharHandler")) {
            XML_MAPPER.getFactory().getXMLOutputFactory().setProperty("com.ctc.wstx.outputInvalidCharHandler", new InvalidCharHandler.ReplacingHandler('?'));
        }
        if (XML_MAPPER.getFactory().getXMLInputFactory().isPropertySupported("com.ctc.wstx.allowXml11EscapedCharsInXml10")) {
            XML_MAPPER.getFactory().getXMLInputFactory().setProperty("com.ctc.wstx.allowXml11EscapedCharsInXml10", true);
        }
    }
}

