/*
 * Decompiled with CFR 0.152.
 */
package com.teamscale.index.metadata.abap;

import com.teamscale.commons.utils.ParameterFileUtils;
import com.teamscale.index.metadata.abap.AbapFileMetadata;
import com.teamscale.index.metadata.abap.EAbapLanguageVersion;
import com.teamscale.index.metadata.abap.EAbapProgramType;
import com.teamscale.index.metadata.abap.ECompatibilityContract;
import com.teamscale.index.metadata.abap.EReleaseState;
import com.teamscale.index.metadata.abap.ReleaseContract;
import eu.cqse.check.framework.scanner.ELanguage;
import java.util.EnumSet;
import java.util.List;
import java.util.Set;
import java.util.function.Consumer;
import org.conqat.lib.commons.collections.CollectionUtils;
import org.conqat.lib.commons.collections.Pair;
import org.conqat.lib.commons.string.StringUtils;

public class AbapFileMetadataReader {
    public static final String ABAP_METADATA_FILE_EXTENSION = "metadata";
    public static final EnumSet<ELanguage> LANGUAGES_WITH_ABAP_METADATA_FILES = EnumSet.of(ELanguage.ABAP, ELanguage.ABAP_DDIC, ELanguage.ABAP_CDS);
    private static final Set<String> METADATA_FIELDS = CollectionUtils.asHashSet((Object[])new String[]{"creationDate", "lastUpdateDateTime", "originatingSystem", "programType", "authorizationGroup", "languageVersion", "isRfcEnabled", "isGeneratedCode", "subObjectName", "subObjectType", "compatibilityContract", "releaseState", "useInKeyUserApps", "useInSapCloudPlatform"});

    private static boolean hasReleaseContractInfos(String fileContents) {
        return fileContents.contains("subObjectName") || fileContents.contains("subObjectType") || fileContents.contains("compatibilityContract") || fileContents.contains("releaseState") || fileContents.contains("useInKeyUserApps") || fileContents.contains("useInSapCloudPlatform");
    }

    public static boolean isMetadataFile(String uniformPath) {
        return uniformPath.endsWith(".metadata");
    }

    public static String getFileNameFromMetadataFile(String uniformPath) {
        return StringUtils.stripSuffix((String)uniformPath, (String)".metadata");
    }

    public static AbapFileMetadata parseFileContents(String filename, String fileContents, Consumer<String> errorReporter) {
        AbapFileMetadata fileMetadata = new AbapFileMetadata(filename, 0L, 0L, null, null, null, null, null, false, false);
        List lines = StringUtils.splitLinesAsList((String)fileContents);
        ReleaseContract releaseContract = ReleaseContract.getEmptyContract();
        for (String line : lines) {
            Pair<String, String> parameterNameAndValue = ParameterFileUtils.findParameterNameAndValue(line, METADATA_FIELDS);
            if (parameterNameAndValue != null) {
                AbapFileMetadataReader.saveFieldAndValueIntoMetadata(fileMetadata, releaseContract, parameterNameAndValue);
                continue;
            }
            errorReporter.accept("Unknown parameter in file " + filename + " on line\\n" + line);
        }
        if (AbapFileMetadataReader.hasReleaseContractInfos(fileContents)) {
            fileMetadata.setReleaseContract(releaseContract);
        }
        return fileMetadata;
    }

    private static void saveFieldAndValueIntoMetadata(AbapFileMetadata metadata, ReleaseContract releaseContract, Pair<String, String> fieldNameAndValue) {
        String fieldName;
        switch (fieldName = (String)fieldNameAndValue.getFirst()) {
            case "creationDate": {
                metadata.setCreationDate(Long.parseLong((String)fieldNameAndValue.getSecond()));
                break;
            }
            case "lastUpdateDateTime": {
                metadata.setLastUpdateDateTime(Long.parseLong((String)fieldNameAndValue.getSecond()));
                break;
            }
            case "originatingSystem": {
                metadata.setOriginatingSystem((String)fieldNameAndValue.getSecond());
                break;
            }
            case "authorizationGroup": {
                metadata.setAuthorizationGroup((String)fieldNameAndValue.getSecond());
                break;
            }
            case "programType": {
                EAbapProgramType programType = EAbapProgramType.valueOf((String)fieldNameAndValue.getSecond());
                metadata.setProgramType(programType);
                break;
            }
            case "languageVersion": {
                EAbapLanguageVersion languageVersion = EAbapLanguageVersion.valueOf((String)fieldNameAndValue.getSecond());
                metadata.setLanguageVersion(languageVersion);
                break;
            }
            case "isRfcEnabled": {
                metadata.setRfcEnabled(Boolean.parseBoolean((String)fieldNameAndValue.getSecond()));
                break;
            }
            case "isGeneratedCode": {
                metadata.setCodeIsGenerated(Boolean.parseBoolean((String)fieldNameAndValue.getSecond()));
                break;
            }
            default: {
                AbapFileMetadataReader.saveReleaseContractIntoMetadata(releaseContract, fieldName, fieldNameAndValue);
            }
        }
    }

    private static void saveReleaseContractIntoMetadata(ReleaseContract releaseContract, String fieldName, Pair<String, String> fieldNameAndValue) {
        switch (fieldName) {
            case "subObjectName": {
                releaseContract.setSubObjectName((String)fieldNameAndValue.getSecond());
                break;
            }
            case "subObjectType": {
                releaseContract.setSubObjectType((String)fieldNameAndValue.getSecond());
                break;
            }
            case "compatibilityContract": {
                releaseContract.setCompatibilityContract(ECompatibilityContract.getCompatibilityContract((String)fieldNameAndValue.getSecond()));
                break;
            }
            case "releaseState": {
                releaseContract.setReleaseState(EReleaseState.getReleaseStateFromName((String)fieldNameAndValue.getSecond()));
                break;
            }
            case "useInKeyUserApps": {
                releaseContract.setUseInKeyUserApps(Boolean.parseBoolean((String)fieldNameAndValue.getSecond()));
                break;
            }
            case "useInSapCloudPlatform": {
                releaseContract.setUseInSapCloudPlatform(Boolean.parseBoolean((String)fieldNameAndValue.getSecond()));
                break;
            }
        }
    }
}

